function [UB, x] = curUB(V, UR, Y, n, k, Dbar)
%% INPUT:  V denotes facial reducer
%%         UR denotes eigenvector of R such that V*UR denotes eigenvectors of Y [R=(UR)dR(UR)'; Y=VRV']
%% OUTPUT: UB  upper bound
%%
%% Basic approach using first col. of Y 
    if length(n) == 1
	    n = n*ones(k,1);  % all sets are same size
    end
    x_approx = Y(2:end,1);
    nk = length(x_approx);
    x = zeros(nk, 1);
    inds = 1;
    for i=1:k  % Choose the max weight for the rotamer; set the index to 1
        curRotamer = x_approx(inds:inds+n(i)-1);
        [~, maxIndex] = max(curRotamer);
        x(inds-1+maxIndex) = 1;
        inds = inds+n(i);
    end
    UB = x'*Dbar*x;
%% Approach using dominant eigenvector of Y
    VUR = V*UR(:,end); y_approx = VUR(2:end,1);
    y = zeros(nk, 1);
    inds = 1;
    for i=1:k
        curRotamer = y_approx(inds:inds+n(i)-1);
        [~, maxIndex] = max(curRotamer);
        y(inds-1+maxIndex) = 1;
        inds = inds+n(i);
    end
    UB2 = y'*Dbar*y;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if UB2 < UB
        UB = UB2;
        x = y;
    end
end
