function [output, x] = Gurobisolver(D0, n, k)
% Solving the original problem using Gurobi for comparisons
%INPUT:  D0 the distance matrix for the objective function
%        n number of points in each set
%        k number of sets
A = kron(eye(k),ones(1,n));
D0(:,1) = [];
D0(1,:) = [];
startmosek = tic;
    cvx_clear
    cvx_begin
    %cvx_solver mosek
    cvx_solver mosek
    variable xgur(n*k,1) binary
    minimize (xgur' * (D0 - 2*min(eig(D0))*eye(n*k)) * xgur)
    subject to
    full(A) * xgur == ones(k,1)
    cvx_end
    output.mosekstatus = cvx_status;
    stopmosek = toc(startmosek);
    output.stopmosek = stopmosek;
    timeskngur(k,n) = stopmosek;

    fprintf('times for mosek %g with n = %i and k = %i \n',stopmosek,n,k)

    %results from cvx method
    if strcmp(cvx_status,'Solved')
        x = xgur;
    else
        fprintf('Gurobi failed with status %s \n',cvx_status)
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    output.x = x;
end
