function [output, Y, R] = CVXsolver(D0, n, k, Gtmp, Vhat, params, options)
%function [output, Y, R] = CVXsolver(D0, n, k, Gtmp, Vhat, params, options)
%%%jul 14 we need to solve (3.6) but after FR 
%% min DY  arrow Y   gangster Y   R psd
% Solving the FR problem IQP_DNNFR   using CVX for comparisons
%% this does NOT solve the NP-hard problem??? but just one relaxation????
%%%        needs to be changed to solve the NP-hard problem????
%%%% fix the upper and lower bounds so they are the same as in ADMMsolver
%%%% D0 is Dbar0 in   curLB????? need to check
%INPUT:  D0 the distance matrix for the objective function
%        n number of points in each set  (vector of sizes if varyingn true)
%        k number of sets
%        Gtmp gangster indices
%        Vhat is facial vector for FR

    vr = size(Vhat,2);
    vn = size(Vhat,1);
    Gtmp0 = Gtmp;
    Gtmpc = ~Gtmp;
    Gtmp0(1,1) = 0;  % gangster indices for zeros
    tempM = speye(vn);
    tempM(1,1) = 0;
    indsdiag = find(tempM);
    tempM = zeros(vn);
    tempM(2:end,1) = 1;
    indscol = find(tempM);


    %   use cvx_solver mosek ???
    cvx_clear
    cvx_begin sdp   quiet
    variable Rcvx(vr,vr) symmetric
    variable Ycvx(vn,vn) symmetric
    dual variable Zd;
    dual variable Ard;  % redundant???
    dual variable td;
    dual variable Gd;
    dual variable Ndz;
    dual variable Ndo;  % redundant???
    dual variable dtrR;
    dual variable dtrY;
    dual variable Rd;
    minimize(D0(:)'*Ycvx(:));
    subject to
         Zd : Ycvx - Vhat*Rcvx*Vhat' == 0;
 	 Ard : Ycvx(indsdiag) - Ycvx(indscol) == 0;  % redundant???
         td : Ycvx(1,1) == 1;
         Gd : Ycvx(Gtmp0) == 0;
         Ndz : Ycvx(Gtmpc) >= 0;
         Ndo : Ycvx(:) <= 1;  % redundant???
	 dtrR : trace(Rcvx) - k - 1 == 0;
	 dtrY : trace(Ycvx) - k - 1 == 0;
         Rd    : Rcvx >= 0;
    cvx_end
    %%% verify arrow constraint is redundant approx
    %residarrow = norm(Ycvx(indsdiag) - Ycvx(indscol));
    %if residarrow  > 1e-6
%	    fprintf('arrow not redundant CVXsolver %g\n',residarrow)
%	    keyboard
%    end

    
    %results from cvx method
    if strcmp(cvx_status,'Solved')
	%% greedy for upper bound
        R = Rcvx;
        Y = Vhat*Rcvx*Vhat';


	if length(n) == 1
	    n = n*ones(k,1);  % all sets are same size
    	end
    	x_approx = Y(2:end,1);
    	nk = length(x_approx);
    	x = zeros(nk, 1);
    	inds = 1;
    	for i=1:k  % Choose the max weight for the rotamer; set the index to 1
        	curRotamer = x_approx(inds:inds+n(i)-1);
        	[~, maxIndex] = max(curRotamer);
        	x(inds-1+maxIndex) = 1;
        	inds = inds+n(i);
    	end
    	ubd = x'*D0(2:end,2:end)*x;


        %ubd = x'*D0(2:end,2:end)*x;  % old way
        %lbd = cvx_optval - cvx_slvtol;   % old way
	%Zpp = Zd;
        %lbd = curLB(D0, Zpp, Vhat, Gtmp, k);
        relgap = cvx_slvtol/(abs(ubd)+1);
	lbd = ubd - cvx_slvtol;  % is this really a lower bnd????
    else
        fprintf('CVX failed with status %s \n',cvx_status)
	R = [];
	Y = [];
	x = []
	ubd = inf;
	lbd = -inf;
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    output.lbd = lbd;
    output.ubd = ubd;
    output.relgap = relgap;
    output.Y = Y;
    output.R = R;
end
