#include "nr.h"
#include "random_seq.h"
#include <time.h>
#include <stdlib.h>

int main (void)
{
        char sequence[101];
        long seed;
        time_t currtime;

        time (&currtime);
        seed = -abs((long)(currtime));
        
	random_seq(sequence, 100, &seed);
        sequence[100] = '\0';
        printf("%ld %s\n", seed, sequence);
        return 0;
}

/* random_seq.c */
/* calls ran2 to make a random sequence */

#include "random_seq.h"

char *random_seq (char *sequence, long length, long *seed)
{	
	long i;

	for (i=0; i<length; i++)
	{
		sequence[i] = float_to_nt(ran2(seed));
	}
	return sequence;
}

char float_to_nt (float f)
{
	if (f < 0.5)
	{
		if (f < 0.25)
			return 'U';
		else
			return 'C';
	}
	else
	{
		if (f < 0.75)
			return 'A';
		else
			return 'G';
	}
}

