package taskspaces.system;

/**
 * Provides a data structure and blocking methods for
 * Tasks to be passed between Servers and Workers.
 * @author Rob Markel, Matthew Keoshkerian
 * @version 2.0
 */ 
public class TaskStore implements java.io.Serializable
{
   /** Holds a Task. */
   private Object contents;

   /** Indicates if a Task is available. */
   private boolean available=false;

    /**
     * Returns a Task if one is available, otherwise
     * the caller is blocked.
     * @return a Task object.
     */
   public synchronized Object get()
   {
      // If there isn't a task available, wait here until one is available.
      while(available==false)
      {
         try {wait();}
         catch(InterruptedException e) {}
      }
      
      // Since available has been made true, set it to false and return the content.
      available=false;
      notifyAll();
      return contents;
   }
 
    /**
     * Stores a Task if this store is empty, otherwise
     * the caller is blocked.
     * @return void 
     */
   public synchronized void put(Object o)
   {
      // If there is a task available, wait until there isn't one.
      while(available==true)
      {
         try {wait();}
         catch(InterruptedException e) {}
      }
      
      // Set the contents and notify that the system has a task available.
      contents=o; 
      available=true;
      notifyAll();
   }
}
