package taskspaces.system;

import java.io.*;

/**
 * Superclass of all Tasks, holds memebers for 
 * Node references set on arrival at a Node and
 * defines run method to be overriden by application
 * Tasks.
 * @author Rob Markel, Matthew Keoshkerian
 * @version 2.0
 */
public class Task extends Communicator implements Cloneable
{
   /** Holds a reference to the host Node. */
   public Node node;

   /** Holds the number of tasks for this application. */
   public long tasks;

   /** Identifier. */
   public int id;

   /**
    * Passes a Node reference to this Task.
    * @param node the host Node.
    * @return void
    */
   public void setNode(Node node) {this.node=node;}

   /**
    * Returns a clone of this Task.
    * @return the cloned object. 
    */
   public Object next()
   { 
      this.nextData();
      Cloneable o=null;
      try
      {
         o=(Cloneable)this.clone();
      } catch(Exception e) {e.printStackTrace();}
      return o; 
   }

   /**
    * Advances the data for the next Task object, overriden by SPMD subclasses.
    * @return void
    */
   public void nextData() {}
 
   /**
    * Overriden by subclasses.
    *@return void
    */
   public void run() {}

   /**
    * Return the ID of this task.
    * @return the int "id"
    */
   public int getId() 
   { 
      return this.id; 
   }
}
