import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Begins execution of applications or system components with 
 * the properties and resource URLs passsed on the command line.
 * The properites URL is the first argument, then any number of 
 * HTTP resource URL containing class or JAR files may be passed.
 * The class name to be executed is taken as the final argument.
 * @author Rob Markel, Matthew Keoshkerian
 * @version 2.0 
 */
public class Runner 
{
   /**
    * Main method of the Runner class
    * This method takes in the arguments and the URLs from the properties files and uses them
    * to execute a class from a remote location accessed through http.
    * @param a The array of arguments (seperated by ' ') from the command line execution.
    * @return void
    */
   public static void main(String[] a) throws Exception
   {
	  
	  // Grab the length of the arguments array.
      int args=a.length;
      
      // If Runner was not executed with enough arguments, tell the user and kill the execution
      if(!(args>=2)) 
      {
         System.out.println("Usage: java Runner <properties URL> [urls] <classname>"); 
         System.exit(0);
      }

      // Create a new properties object and get the location of the properties file.
      Properties p=new Properties();
      String propsAddress="http://"+a[0];
      
      // Create a URL object for the location of the properties.
      URL url=new URL(propsAddress);
      
      // Set the System Property for the location fo the properties file.
      System.setProperty("propsAddress",propsAddress);
      
      // Open up a buffered reader to the properties file and load the file then close the stream.
      BufferedInputStream bis=new BufferedInputStream(url.openStream());
      p.load(bis);
      bis.close();

      // Create a new ArrayList to hold all the relevant URLs.
      ArrayList urlList=new ArrayList();
      
      // Take the resources property, split them up, and place them in the urlList array
      String resourceList=p.getProperty("resources");
      StringTokenizer tokenizer=new StringTokenizer(resourceList,","); 
      while(tokenizer.hasMoreTokens())
      {
      	// Take the String and make it into a URL object then place in the list.
        URL resourceUrl=new URL("http://"+tokenizer.nextToken());
        urlList.add(resourceUrl);
      }
      
      // Take the URLs (if any) from the argument line and place them into the ArrayList as well.
      for(int i=1; i<args-1; i++)
      {
         URL argumentUrl=new URL("http://"+a[i]);
         urlList.add(argumentUrl);
      }
      
      // Create a new URL array and copy all the elements from the ArrayList 'urlList' into the array.
      URL[] urls=new URL[urlList.size()];
      for(int i=0; i<urls.length; i++)
      {
         urls[i]=(URL)urlList.get(i);
      }

      // Place the array of urls into the URLClassLoader object and initialize the class that is specified in the cmd line args.
      URLClassLoader u = new URLClassLoader(urls);
      String name=a[args-1];
      Class c=u.loadClass(name);
      ((Runnable)c.newInstance()).run(); // Run the class
   }
}// Runner class
