package taskspaces.system;

import java.io.PrintWriter;

/**
 * This class stores results generated by tasks which are sent to the Result space
 * and processed by the Reciever quasi-Node
 * @author Rob Markel, Matthew Keoshkerian
 * @version 2.0
 */
public class Result implements java.io.Serializable
{
	/** The id of the task sending this result. */
	public int id;
	
	/** The object which will be sent back as a result. */
	public Object resultObject;

	/** 
	 * Constructor for the Result class
	 */
	public Result(int id, Object resultObject)
	{
		// Set the global values "id" and "resultObject".
		this.id = id;
		this.resultObject = resultObject;
	}

	/**
	 * This method is incomplete. It only throws an exception.
	 * @param pw The Print Writer to be used.
	 * @return void
	 */
	public void print(PrintWriter pw) throws Exception
	{
		throw new Exception("print() not implemented!");
	}

	/**
	 * This method returns the class variable getResultObject
	 * @return resultObject
	 */
	public Object getResultObject()
	{
		return resultObject;
	}
  
	/**
	 * This method returns the class variable getId
	 * @return id
	 */
	public int getId()
	{
		return id;
	}
}
