package taskspaces.system;

/**
 * This class is the superclass to all TaskSpaces
 * Agents. It holds the data members which allow
 * Agents to interact with Spaces and Nodes. 
 * The Agent class also provides a type for
 * Spaces and Nodes to determine if an
 * arriving object is an Agent.
 * @author Rob Markel, Matthew Keoshkerian
 * @version 2.0
 */
public class Agent extends Communicator
{
   /** Reference to hosting Node. */
   public Node node;

   /** Reference to hosting Space. */
   public Space space;

   /**
    * This method allows Nodes to send references to 
    * themselves to the Agent. Once the reference is
    * passed (by the Node) the Agent can execute the
    * Node's public methods. The Node reference is set
    * to this class' node member. 
    * @param node the host Node
    * @return void 
    */
   public void setNode(Node node) {this.node=node;}


   /**
    * This method allows Spaces to send self-references to 
    * to the Agent. Once the reference is
    * passed (by the Space) the Agent can execute the
    * Space's public methods. The space reference
    * is set to this class' space member. 
    * @param space the host Node
    * @return void 
    */
   public void setSpace(Space space) {this.space=space;}

   /**
    * This method is overridden by subclasses and
    * executed by Spaces and Nodes. 
    * @return void 
    */
   public void run() {}
}
