package taskspaces.rna;

import java.util.*;

/**
 * Encapsulates a methods to create a map of 
 * paired indices given a dot-bracket notation
 * structure.
 * @author Rob Markel
 * @version 1.0 
 */
public class PairList
{
  /**
   * Constructs a pair list map indicating what indices 
   * are paired in a given dot-bracket notation structure.
   * Translated from original written in Feb 2002 by Rob Knight.
   * @param s a dot-bracket structure. 
   * @return map indicating structure pairings.
   */
   public static HashMap getPairMap(String s)
   {
      char[] structure=s.toCharArray();
      char open='(',closed=')';
      Stack stack=new Stack();
      HashMap partners=new HashMap();
      for(int i=0; i<structure.length; i++)
      {
        char c=structure[i];  
        if(c==open) stack.push(new Integer(i));
        if(c==closed) 
        {
           Integer pairedBase=(Integer)stack.pop();
           partners.put(pairedBase,new Integer(i));
           partners.put(new Integer(i),pairedBase);
        } 
      }
      return partners;
   }
}
