/*test*/
import java.io.*;
import java.net.*;
import java.util.*;
import taskspaces.system.*;
import taskspaces.rna.*;

/**
 * This class is the HelloWorld application for TaskSpaces
 * @version     1.00
 * @author      Hans De Sterck
 */
public class HelloWorld extends Task implements Runnable 
{
   /** File for output data. */
   String outputFile="HelloWorldOutput";

   /** File for status data. */
   String statusFile="HelloWorldStatus";

   /** Writer for output. */
   PrintWriter pw;
    //PrintWriter debug;

   /** Space address to send results. */
   String resultSpace;

   /** For restart. */
   int[] taskList;
    
   /** For logging */
   String user="TaskAgent";
   static String app = "HelloWorld";

   /** 
    * Default constructor for initialization. 
    */
   public HelloWorld() {}

   /** 
    * Constructor for tasks. 
    */
   public HelloWorld(int id, int tasks, String outputFile, String resultSpace)
   {
      this.id=id;
      this.tasks=tasks;
      this.outputFile=outputFile;
      this.resultSpace=resultSpace;
   }


   /**
    * Called by TaskAgent to advance data when creating new Tasks
    * while resident in a Space.
    * @return void
    */
   public void nextData()
   {
      try
      { 
         id++;
      } catch(Exception e) {e.printStackTrace();}
   }

   /**
    * Called by Nodes to execute application. 
    * @return void
    */
   public void run()
   {
      try
      {
         if(id==0)
         {
            // Get input. 
            BufferedReader reader=new BufferedReader(new InputStreamReader(System.in));
            print("This is the HelloWorld application.\nEnter the number of tasks you want to execute:");
            String line=reader.readLine();
			int tasks = Integer.parseInt(line);
            reader.close();

            // Get space addresses.
            String[] spaces=getSpaces();
            String taskSpace=spaces[0];
            String resultSpace=spaces[1];

            // Send task. 
            String statusPath = statusFile.replace('/',File.separatorChar);
            boolean success = (new File(statusPath)).delete();
			PrintWriter statusWriter = new PrintWriter(new FileWriter(statusPath,true));
            BufferedReader br = new BufferedReader(new FileReader(statusPath));
            String str;
            taskList = new int[tasks+1];
            while((str = br.readLine()) != null)
            {
               int idInFile = Integer.parseInt(str);
               taskList[idInFile] = 1;
            }
            HelloWorld task=new HelloWorld((id++),tasks,outputFile,resultSpace);
            print("HelloWorld: Sending task.");

            sendAgent(taskSpace,new TaskAgent(task,taskList, user, "HelloWorld"));  
            print("HelloWorld: Task sent to Space!");

		    print("HelloWorld: Starting result Receiver.");
               new Thread((new Receiver(resultSpace,tasks,outputFile,statusFile,user,app,true))).start();
            return; 
         }
	 
         print("HelloWorld: Task "+String.valueOf(id));

	     String resultSentence=("HelloWorld: Hello World!! Task "+String.valueOf(id));
		 print(resultSentence);

		 Result resultObject = new Result(id,resultSentence);
            
		 send(resultSpace,resultObject);

      } catch(Exception e) {e.printStackTrace(); System.out.println("error"); }
      return;
   } 
}
