import numpy as np
from matplotlib import pyplot as pl

def euler(x0,xN,y0,h,f):
    N = int((xN-x0)/h)+1
    x = np.linspace(x0,xN,N)
    y = np.zeros(x.shape)
    y[0] = y0
    for i in np.arange(N-1):
        y[i+1] = y[i] + h*f(x[i],y[i])
    return x,y,N

x0 = 0
xN = 4
y0 = 1
f = lambda x,y: 1-x*y

h_list = np.logspace(-1,-8,num=8,base=2)
y_old = 0
for h in h_list:
    x,y,N = euler(x0,xN,y0,h,f)
    if h != h_list[0]:
        error = np.sum(np.abs(y[::2]-y_old))/N
        print(h,error)
    pl.plot(x,y)
    y_old = y