x0 = 0;
xN = 4;
y0 = 1;
f = @(x,y) 1-x*y;

h_list = 2.^-(1:8);
y_old = 0;
hold on;
for h = h_list
    [x,y,N] = euler(x0,xN,y0,h,f);
    if h < 0.5
        error = sum(abs(y(1:2:end)-y_old));
        [h,error]
    end
    plot(x,y)
    y_old = y;
end

function [x,y,N] = euler(x0,xN,y0,h,f)
    N = floor((xN-x0)/h)+1;
    x = linspace(x0,xN,N);
    y = zeros(size(x));
    y(1) = y0;
    for i = 1:N-1
        y(i+1) = y(i) + h*f(x(i),y(i));
    end
end