#include <stdio.h>
#include <stdlib.h>

#ifdef LINUX
#include <getopt.h>
#endif

#include "eg_util.h"
#include "eg_macros.h"
#include "eg_kpseparator.h"
#include "eg_2ptighten.h"

void usage (char *program)
{
	fprintf (stdout, "Usage: %s [options]\n", program);
	fprintf (stdout, "Options:\n");
	fprintf (stdout, "     -x d   x file name.\n");
	fprintf (stdout, "     -b     use binary file format.\n");
}

int parseargs (int argc,
							 char **argv,
							 int *binary_file,
							 char **boss_host,
							 char **file_name)
{

	int c;
	char noyes[2][4] = {[0] = "no",[1] = "yes" };

	*file_name = 0;
	*binary_file = 0;
	*boss_host = 0;

	while ((c = getopt (argc, argv, "x:bh:")) != EOF)
	{
		switch (c)
		{
		case 'h':
			*boss_host = optarg;
			break;
		case 'b':
			*binary_file = 1;
			break;
		case 'x':
			*file_name = optarg;
			break;
		default:
			usage (argv[0]);
			return 1;
		}
	}

	if (!*file_name)
	{
		usage (argv[0]);
		return 1;
	}

	/* reporting the options */
	fprintf (stdout, "\n");
	fprintf (stdout, "Parsed Options:\n");
	fprintf (stdout, "input         : %s\n", *file_name);
	fprintf (stdout, "binary files  : %s\n", noyes[*binary_file]);
	fprintf (stdout, "\n");
	fflush (stdout);

	return 0;

}

int main (int argc,
					char **argv)
{
	int rval,
	  i,
	  d,
	  binary_file;
	char *file_name = 0,
	 *boss_host;

	int nnodes,
	  norig_edges,
	 *orig_edges,
	  nIneq,
	 *n2dominoes,
	**naset,
	**nbset,
	**nmset,
	 *nahandle,
	 *nbhandle,
	***aset,
	***bset,
	***mset,
	**ahandle,
	**bhandle;
	double *orig_weight;

	/**** PARSING INPUT ********************************************************/

	rval = parseargs (argc, argv, &binary_file, &boss_host, &file_name);
	CHECKRVAL (rval);

	/**** LOADING X FILE *******************************************************/

	if (binary_file)
	{
		rval =
			loadBGraph (file_name, &nnodes, &norig_edges, &orig_edges, &orig_weight);
		CHECKRVAL (rval);
	}
	else
	{
		rval =
			loadGraph (file_name, &nnodes, &norig_edges, &orig_edges, &orig_weight);
		CHECKRVAL (rval);
	}

	/**** CALLING DPSEPARATOR ***************************************************/

	nIneq = 0;
	rval = DP2separator (nnodes, norig_edges, orig_edges, orig_weight, &nIneq,
											 &n2dominoes, &naset, &nbset, &nmset, &nahandle,
											 &nbhandle, &aset, &bset, &mset, &ahandle, &bhandle,
											 boss_host, 1.0, 10.0, 5.0, 20.0);
	CHECKRVAL (rval);

	/* here we call the tightening.... just to check */
	if (nIneq)
	{
		int ln,
		  nd;
		int *new_naset,
		 *new_nbset,
		 *new_ntset,
		  new_nahandle,
		  new_nbhandle,
		**new_aset,
		**new_bset,
		**new_tset,
		 *new_ahandle,
		 *new_bhandle;
		double violation;
		for (ln = 0; ln < nIneq; ln++)
		{
			rval = KPtighten (nnodes, norig_edges, orig_edges, orig_weight,
												n2dominoes[ln], naset[ln], nbset[ln], nmset[ln],
												nahandle[ln], nbhandle[ln], aset[ln], bset[ln],
												mset[ln], ahandle[ln], bhandle[ln], &new_naset,
												&new_nbset, &new_ntset, &new_nahandle, &new_nbhandle,
												&new_aset, &new_bset, &new_tset, &new_ahandle,
												&new_bhandle, &violation);
			if (new_naset)
			{
				EGfree (new_ahandle);
				EGfree (new_bhandle);
				for (nd = n2dominoes[ln]; nd--;)
				{
					if (new_naset[nd])
						EGfree (new_aset[nd]);
					if (new_nbset[nd])
						EGfree (new_bset[nd]);
					EGfree (new_tset[nd]);
				}
				EGfree (new_naset);
				EGfree (new_nbset);
				EGfree (new_ntset);
				EGfree (new_aset);
				EGfree (new_bset);
				EGfree (new_tset);
			}
		}
	}


	if (nIneq)
	{
		PTRTEST (aset, 1);
		PTRTEST (bset, 1);
		PTRTEST (mset, 1);
		PTRTEST (nbset, 1);
		PTRTEST (naset, 1);
		PTRTEST (nmset, 1);
		PTRTEST (ahandle, 1);
		PTRTEST (bhandle, 1);
		PTRTEST (n2dominoes, 1);
		PTRTEST (nahandle, 1);
		PTRTEST (nbhandle, 1);
		for (i = 0; i < nIneq; i++)
		{
			PTRTEST (aset[i], 1);
			PTRTEST (bset[i], 1);
			PTRTEST (mset[i], 1);
			PTRTEST (nbset[i], 1);
			PTRTEST (naset[i], 1);
			PTRTEST (nmset[i], 1);
			PTRTEST (ahandle[i], 1);
			PTRTEST (bhandle[i], 1);
			for (d = 0; d < n2dominoes[i]; d++)
			{
				PTRTEST (aset[i][d], 1);
				PTRTEST (bset[i][d], 1);
				PTRTEST (mset[i][d], 1);
				if (aset[i][d])
					EGfree (aset[i][d]);
				if (bset[i][d])
					EGfree (bset[i][d]);
				EGfree (mset[i][d]);
			}
			EGfree (naset[i]);
			EGfree (nbset[i]);
			EGfree (nmset[i]);
			EGfree (ahandle[i]);
			EGfree (bhandle[i]);
			EGfree (aset[i]);
			EGfree (bset[i]);
			EGfree (mset[i]);
		}
		EGfree (n2dominoes);
		EGfree (naset);
		EGfree (nbset);
		EGfree (nmset);
		EGfree (aset);
		EGfree (bset);
		EGfree (mset);
		EGfree (ahandle);
		EGfree (bhandle);
		EGfree (nahandle);
		EGfree (nbhandle);

	}

	PTRTEST (orig_edges, 1);
	PTRTEST (orig_weight, 1);
	EGfree (orig_edges);
	EGfree (orig_weight);

	return 0;

}
