/* ========================================================================= */
/** @mainpage Domino Parity Separator Home Page
 *
 * @section Introduction
 
 <P>This is a joint project of <A HREF=http://www.isye.gatech.edu/~wcook TARGET=_top>William Cook</A>, <A HREF=http://www.isye.gatech.edu/~despinoz TARGET=_top>Daniel Espinoza</A> and <A HREF=http://www.isye.gatech.edu/~mgoycool TARGET=_top>Marcos Goycoolea</A> that started in 2003. The idea was to implement <A HREF=http://www.lancs.ac.uk/staff/letchfoa TARGET=_top>Adam Letchford's</A> separation algorithm for Domino Parity Inequalities for the TSP, as described in "Separating a superclass of comb inequalities in planar graphs", Math. Oper. Res., 25(3), 443-454.</P>

 <P>This implementation deals with the problem of separating such inequalities even in the case when the support graph is non-planar (in wich case the separation algorithm is heuristic), parallelization of the main domino-building step, and also heuristics to find more than one violated inequality.</P>

 <P>As part of our research we also introduced the so-called K-Parity constraints, and this code provide an heuristic to separate 2-Parity constraints.<P>

 <P>For more details see the paper <A HREF=http://www.isye.gatech.edu/~despinoz/PApers/DP_paper.pdf TARGET=_top>"Computing with Domino-Parity Inequalities for the TSP"</A>. For those intersted in the source code, you can get it <A HREF=http://www.isye.gatech.edu/SOurce/KP-051020.tar.bz2 TARGET=_top>here</A>.</P>

@section B Acknowledgments

<P>Special thanks to <A HREF=http://pacificcoast.net/~lightning/jboyer.htm TARGET=_top>John Boyer</A> for allowing us to use his excelent implementation of the Boyer-Myrvold planarity testing algorithm. And to <A HREF=http://www.research.ibm.com/people/s/sanjeebd/ TARGET=_top>Sanjeeb Dash</A> for allowing us to use his implementation of <A HREF=http://theory.csail.mit.edu/~karger/ TARGET=_top>David Karger's</A> algorithm to find <A HREF=http://theory.lcs.mit.edu/~karger/Papers/contract.ps TARGET=_top>minimum cuts</A>.</P>
 * */
