#ifndef __EG_UTIL_H__
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "dp_config.h"
#include "eg_mempool.h"
#include "bc_util.h"
#include "eg_nettype.h"
#include "eg_dijkstra.h"
#include "eg_ddomino.h"
#include "eg_dgraph.h"
#include "eg_ugraph.h"
#include "eg_menger_app.h"

/* eliminate all small edges (cut-off value is a constant defined here 
 * as maxval ) */
int removeSmallEdges (double maxval,
											int *orig_edges,
											int norig_edges,
											double *orig_weight,
											int *nedges,
											int **edges,
											double **weight,
											EGmemPool_t * mem);

/* load a graph into cook's format but reading from a binary file, the memory 
 * is not managed through EGmemPool, we might want to change that later on */
int loadBGraph (const char *file,
								int *nNodes,
								int *nEdges,
								int **edges,
								double **weight);

/* load a graph into cook's format, the memory is not managed through EGmemPool,
 * we might want to change that later on */
int loadGraph (const char *file,
							 int *nNodes,
							 int *nEdges,
							 int **edges,
							 double **weight);

/* save a graph in binary format */
int saveBgraph (const char *file_name,
								int nnodes,
								int nedges,
								int *edges,
								double *weight);

int saveGraph (const char *file_name,
							 int const nnodes,
							 int const nedges,
							 int const *const edges,
							 double const *const weight);

int saveSubGraph (const char *file_name,
									int nnodes,
									int nsubedges,
									int *edges,
									int *subedges,
									double *weight);

/* recieve a graph through a socket */
int EGreceiveRealGraph (CC_SFILE * s,
												EGdGraph_t ** biDualG,
												EGmemPool_t * mem);

/* recieve a graph through a socket */
int EGsendRealGraph (CC_SFILE * s,
										 EGdGraph_t * biDualG,
										 EGdGraphEdge_t *** dedges,
										 EGdGraphNode_t *** dnodes,
										 EGmemPool_t * mem);

/* recieve a graph through a socket */
int EGreceiveNetGraph (CC_SFILE * s,
											 unsigned int *nnodes,
											 unsigned int *nedges,
											 unsigned int **edges,
											 double **weight,
											 EGmemPool_t * mem);

/* recieve a graph through a socket */
int EGsendNetGraph (CC_SFILE * s,
										unsigned int nnodes,
										unsigned int nedges,
										unsigned int *edges,
										double *weight);

/* send dominoes */
int EGsendRealDomino (CC_SFILE * s,
											EGddomino_t * ddom);

/* send dominoes */
int EGreceiveRealDomino (CC_SFILE * s,
												 EGddomino_t ** ddom,
												 EGdGraphEdge_t ** dedges,
												 EGdGraphNode_t ** dnodes,
												 EGmemPool_t * mem);

/* send dominoes */
int EGsendNetDomino (CC_SFILE * s,
										 EGnetDdom_t * ddom);

/* send dominoes */
int EGreceiveNetDomino (CC_SFILE * s,
												EGnetDdom_t ** ddom,
												EGmemPool_t * mem);

int EGisCookGraphConnected (int nnodes,
														int nedges,
														int *edges,
														EGmemPool_t * mem);

#endif
