#ifndef _GREEDYKP
#define _GREEDYKP

#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#include "eg_greedytypes.h"
#include "eg_kppairs.h"
#include "karger.h"
#include "eg_greedysample.h"

EGdkdomino_t* EGdcutToDKdom(unsigned int max_k, 
                            EGdualCut_t *dc, 
														unsigned int orientation, 
														EGmemPool_t *mem);

EGdkdomino_t *EGddominoToDKdom(EGddomino_t *ddom, 
                               int h, 
                               int max_nh, 
                               EGgreedyData_t *gdata,
                               EGmemPool_t *mem,
															 unsigned char *const pndummy,
															 unsigned char *const pedummy);

void EGfreeDKdomino(void *v, EGmemPool_t *mem);

EGgreedyData_t* EGnewGreedyData(EGmemPool_t *mem);
void EGfreeGreedyData(void *vdata);

int EGfillGreedyData (EGgreedyData_t * data,
											EGdGraph_t * bdG,
											EGlist_t * ddom_list,
											EGlist_t** dembed,
											graphP G,
                      int norig_nodes,
                      int norig_edges,
                      int nplanar_edges,
                      int *orig_edges,
                      int *planar_edges,
                      double *orig_weight,
                      double *planar_weight);

EGdualCut_t* EGnewDualCut(EGmemPool_t *mem, 
                          unsigned int sz);

EGdualCut_t* EGcopyDualCut(EGmemPool_t *mem, 
                           EGdualCut_t *dc_in);

void EGfreeDualCut(void *v, 
                   EGmemPool_t *mem);

EGdcutIter_t* EGnewDcutIter(EGgreedyData_t *gdata);
void EGfreeDcutIter(void *v);

EGdkpc_t* EGdkdomToDKPC(EGdkdomino_t *dkdom,
										    EGmemPool_t *mem);

EGdkpc_t* EGdcutToDKPC(EGdualCut_t *dc, 
                    unsigned int orientation, 
										EGmemPool_t *mem);


void EGfreeDKPC(void *v, 
                EGmemPool_t *mem);

int EGincrementDcutIter(EGdcutIter_t *zit);
EGdualCut_t* EGgetDcut(EGdcutIter_t *zit);

int EGgetEvenPrec (unsigned int s, 
                   unsigned int t, 
									 EGgreedyData_t*data);

int EGgetOddPrec (unsigned int s, 
                  unsigned int t, 
									EGgreedyData_t*data);

/** note that s and t are not sorted in any way, the corresnpond to a node ID
 * in the bdG graph */
EGdijkstraCost_t EGgetEvenDistance (unsigned s, 
                                    unsigned t, 
																		EGgreedyData_t*data);

#if EG_KP_HEURISTIC
EGdijkstraCost_t EGgetOddDistance (unsigned s, 
                                   unsigned t, 
																	 EGgreedyData_t*data);
#endif

void EGdisplayDualCut(FILE *fout, EGdualCut_t* dc);
void EGdisplayInternalPair(FILE *fout, EGinternalPairs_t *p);
void EGdisplayDKdomino(FILE *fout, EGdkdomino_t *dkdom);
void EGdisplayDKPC(FILE *fout, EGdkpc_t *dkpc);

void EGtraceDistance(unsigned int s, 
                     unsigned int t, 
										 EGgreedyData_t *data);

int EGextractEEpath(unsigned int s, 
                    unsigned int t, 
										EGgreedyData_t *data, 
										EGlist_t *path);

EGdualCut_t* EGextractHandleCut(EGdkpc_t *dkpc, unsigned int h);

int EGgrowHandle(EGdkpc_t *dkpc, 
                 EGdkdomino_t *link_dkdom,
                 EGinternalPairs_t *p, 
								 EGgreedyData_t *data,
								 EGmemPool_t *mem,
								 unsigned char *const pndummy,
								 unsigned char *const pedummy);

int EGremoveHandles(EGdkpc_t *dkpc, EGmemPool_t *mem);

int EGgrowDKdomino(EGdkdomino_t *dkd, 
                   EGinternalPairs_t *p,
                   int handle_num,
									 EGmemPool_t *mem);

int EGprimalizeDKPC (EGdkpc_t *dkpc,
                     EGgreedyData_t *gdata,
                     EGpkpc_t *pkpc,
										 unsigned char *const pndummy,
										 unsigned char *const pedummy);

int EGprimalizeDKPCB(EGdkpc_t *dkpc,
                     EGgreedyData_t *gdata,
                     int *nhandles,
                     int **handle_size,
                     int ***handles,
                     int *nteeth,
                     int **teeth_size,
                     int ***teeth,
                     int **teeth_k,
                     int ***teeth_handle,
                     int ***teeth_nhalf,
                     int ****teeth_halves,
										 unsigned char *const pndummy,
										 unsigned char *const pedummy);

int EGnewPKPCset(int nineq,
                 int **nhandles,
                 int ***handle_size,
                 int ****handles,
                 int **nteeth,
                 int ***teeth_size,
                 int ****teeth,
                 int ***teeth_k,
                 int ****teeth_handle,
                 int ****teeth_nhalf,
                 int *****teeth_halves);

void EGfreePKPC(void *v); 

int EGfreePKPCB(int nhandles,
                int *handle_size,
                int **handles,
                int nteeth,
                int *teeth_size,
                int **teeth,
                int *teeth_k,
                int **teeth_handle,
                int **teeth_nhalf,
                int ***teeth_halves );

double EGcomputeInterfaceValue(int T_size, 
                               int *T_nodes, 
                               int A_size,
                               int *A_nodes,
                               int nnodes, 
                               int nedges, 
                               int *edges,
                               double *weight,
                               unsigned char *dummy);

void EGcomputeDualCutValue(EGdualCut_t *dc);

double EGcomputePrimalCutValue(EGgreedyData_t*data,
															 EGpkpc_t*pkpc,
															 int set_size, 
                               int *set_nodes, 
                               int nnodes, 
                               int nedges, 
                               int *edges,
                               double *weight,
                               unsigned char *dummy);

EGdijkstraCost_t EGcomputeDKPCslack(EGdkpc_t *dkpc);

double EGcomputePKPCslack( EGgreedyData_t*data,
													 EGpkpc_t *pkpc,
                           int nnodes,
                           int nedges,
                           int *edges,
                           double *weight);

int EGkpTo2pTooth( int kp_size,
                   int* kp_nodes,
                   int kp_k,
                   int* kp_handles,
                   int* kp_nhalf,
                   int** kp_halves,
                   int *tp_naset,
                   int *tp_nbset,
                   int *tp_nmset,
                   int **tp_aset,
                   int **tp_bset,
                   int **tp_mset,
                   int nnodes,
                   unsigned char *vdummy );

double EGcomputePKPCBslack(EGgreedyData_t*data,
													 EGpkpc_t*pkpc,
													 int nhandles,
                           int *handle_size,
                           int **handles,
                           int nteeth,
                           int *teeth_size,
                           int **teeth,
                           int *teeth_k,
                           int **teeth_handle,
                           int **teeth_nhalf,
                           int ***teeth_halves,
                           int nnodes,
                           int nedges,
                           int *edges,
                           double *weight);

int KPseparateFromDualCut( EGdualCut_t *dcut,
                           unsigned int orientation,
                           EGgreedyData_t *gdata,
                           int *nadded,
                           double *minslack,
													 double sample_time);

void EGdisplayStatus(FILE *fout, EGgreedyData_t *gdata);

int EGaddDualCutToHeap(EGheap_t *h, 
                       EGdualCut_t *dc, 
                       int orientation,
                       double lfval,
                       EGmemPool_t *mem);

int KPprocess_cut(int*cutset,int cutsize,double cutweight,void*process_indo,setlist**sets);

int EGareDualCutsEqual(EGdualCut_t *a, EGdualCut_t *b);

#endif
