#ifndef __DP_TIGHTEN_C__
#define __DP_TIGHTEN_C__

/* ========================================================================= */
/* define the debug level to use for this program, the efect depend on the DEBUG
 * constant defined at compile time, if that variables is >= to the level
 * indicated here we will make more tests */
#define DPT_DBG 10							/* test basic conditions */
#define DPT_EDBG 10							/* make exhaustive test of conditions */
#define DPT_VRB 10							/* fully log the program trace */

/* ========================================================================= */
/* given a residual graph G^*, and a valid DP inequality, it will try to find a
 * 'more' violated DP-inequality constraint; the function will not touch the
 * data abour the graph nor about the original inequality, but it will alloc
 * memory for all data in the new returned inequality. Note too that the number
 * of dominos of the new inequality is the same as in the original inequality.
 * Finaly, the violation (if it is positive) of the new inequality is returned
 * in (*violation). If an error occurs the function will return 1, zero on
 * success (this doesn't imply that we were able to find a violated constraint
 * from the original onw */
int DPtighten (									/* graph G* data */
								int n_nodes,
								int n_edges,
								int *edges,
								double const *const weight,
								/* original constrain to tighten */
								int n_dominos,
								int *n_aset,
								int *n_bset,
								int n_handle,
								int **aset,
								int **bset,
								int *handle,
								/* new generated constraint */
								int **new_n_aset,
								int **new_n_bset,
								int *new_n_handle,
								int ***new_aset,
								int ***new_bset,
								int **new_handle,
								double *violation);
#endif
