#include "eg_ddomino_app.h"

int EGddominoTest (char *file_name)
{

	int i,
	  rval;
	FILE *file;

	int nnodes,
	  nedges,
	 *edges;
	EGdijkstraCost_t *weight;

	double dtmp;

	size_t *os = 0;
	EGlist_t *dlist;

	EGdGraph_t *G;

	EGtimer_t my_timer;
	EGmemPool_t *mem;

	/**** LOADING GRAPH ********************************************************/

	file = fopen (file_name, "r");
	TEST (!file, "unable to open file %s", file_name);

	fscanf (file, "%d %d", &nnodes, &nedges);

	edges = (int *) malloc (sizeof (int) * nedges * 2);
	weight = (EGdijkstraCost_t *) malloc (sizeof (EGdijkstraCost_t) * nedges);

	for (i = 0; i < nedges; i++)
	{
		fscanf (file, "%d %d %lf", &edges[2 * i], &edges[2 * i + 1], &dtmp);
		weight[i] = EGdijkstraToCost (dtmp);
	}

	fclose (file);

	/**** RUNNING ALGORITHM *****************************************************/

	mem = EGnewMemPool (8192, EGmemPoolNewSize, EGmemPoolNewSize (1));

	G = EGnewMengerGraph (mem, nnodes, nedges, edges, weight, &os);

	EGtimerReset (&my_timer);
	EGtimerStart (&my_timer);

	dlist = EGnewList (mem);

	rval = EGddominoComputeAll (mem, G, dlist);
	CHECKRVAL (rval);

	EGtimerStop (&my_timer);

	fprintf (stderr, "Found %u ddominoes.\n", dlist->size);
	fprintf (stderr, "Time: %lf\n", my_timer.time);

	/**** LIBERATING MEMORY  ****************************************************/

	EGmemPoolFree (os, sizeof (size_t) * 13, mem);

	EGdGraphClearMP (G, EGfreeMengerEdgeDataMP, EGfreeMengerNodeDataMP, 0, mem,
									 mem, 0);
	EGfreeDGraph (G);

	EGfreeAllDDominoes (dlist, mem);
	EGfreeList (dlist);
	EGfreeMemPool (mem);

	free (edges);
	free (weight);

	return 0;

}
