#ifndef __DP_CONFIG_H__
#define __DP_CONFIG_H__
/* This is the version string used for the program */
#define DP_VERSION_STRING "05-10-14-0924"

/* Used internally for handling numerical issues related to dual dominoes and
 * dual-2-dominoes. Basically, if the value of a dual-tooth is between
 * DP_RESET_VALUE and 0.0, then the dual-tooth's value is reset to 0.0. On the
 * other hand, if dual-tooth's value is less than DP_RESET_VALUE the program
 * will complain that the SEC conditions are not satisfied. */
#ifndef DP_RESET_VALUE
#define DP_RESET_VALUE -0.002
#endif

/* this manages the minimum violation value for the inequalities found. */
#ifndef DP_MAXVIOLATED_EPSILON
#define DP_MAXVIOLATED_EPSILON 0.0001
#endif

/* set to one if while updating the list of current cuts we use the best
 * violation criterion */
#define DDPC_BEST_VIOLATION 1

/* set to one if we replace cuts 'dominated' by the new one (were domination
 * depend on the definiton of DP_BIG_ANGLE */
#define DDPC_REPLACE_CLOSE 1

/* this manages the threshold of selection for DP cuts */
#define DP_BIG_ANGLE 0.55

/* set this to one if we want to improve the 'spread' of our inequalities
 * according to SELECT_MIN_NORM and DP_MAXDECREASE */
#define DDPC_IMPROVE_SPREAD 1

/* this determine up to what point we want to decrease the norm */
#define SELECT_MIN_NORM 1.5

/* this factor is how much we allow the quiality of the cut to decreas if we
 * increas the worst angle */
#define DP_MAXDECREASE 0.5

/* how we choose the midle path when we untangle de dominoes */
#define DP_LONGEST  1
#define DP_SHORTEST 2
#define DP_LIGHTEST 3
#define DP_HEVIEST  4
#ifndef DP_CHOOSE_MIDDLE
#define DP_CHOOSE_MIDDLE DP_LONGEST
#endif

/* Original edges (those passed by concorde) whose value are below
   ZERO_X_EPSILON are eliminated */

#ifndef ZERO_X_EPSILON
#define ZERO_X_EPSILON 0.000001
#endif

#ifndef CHECK_MODE
#define CHECK_MODE 0
#endif

#ifndef DISPLAY_MODE
#define DISPLAY_MODE 1
#endif

#ifndef DISPLAY_RESOLUTION
#define DISPLAY_RESOLUTION 10
#define IDR (1.0/DISPLAY_RESOLUTION)
#endif

#ifndef LOG_MODE
#define LOG_MODE 1
#endif

#ifndef ELIM_EDGES
#define ELIM_EDGES 1
#endif

/* control the reduction of paths of ones in G*, if setted to one we keep at
 * most three edges of a consecutive one path in bdualG */
#ifndef __DP_ONES_PATH_CONTRACT__
#define __DP_ONES_PATH_CONTRACT__ 1
#endif

/*** eg_ddomino.h ***/

/* This constant determines how much less than 4.0 the path sum defining
   the domino has to be */

#ifndef DDOM_EPSILON
#define DDOM_EPSILON 0.00001
#endif

/* This is a speed up. It eliminates nodes 't' from the graph whose distance
   to 's' is greater than 4.5/3 (look at this!!!) */

#ifndef DDOM_LARGE_MODE
#define DDOM_LARGE_MODE 1
#endif

#ifndef DP_REMOVE_EMPTY_HANDLES
#define DP_REMOVE_EMPTY_HANDLES 1
#endif

/* this flag determines wether or not to use the heuristic which uses 
   graph M^* to find additional violated cuts */

#ifndef DDP_HEURISTIC
#define DDP_HEURISTIC 1
#endif

#ifndef DDP_HEURISTIC_CHANCES
#define DDP_HEURISTIC_CHANCES 15
#endif

// How much time the 1P separator dedicates to generating violated cuts
extern double DDP_HEURISTIC_MAXTIME;

// How many cuts the 1P separator stores
#ifndef DDP_HEURISTIC_MAXCUTS
#define DDP_HEURISTIC_MAXCUTS 500
#endif

#ifndef DDP_MIN_VIOLATION
#define DDP_MIN_VIOLATION 0.001
#endif

#ifndef DDPC_PERTURB_ODD
#define DDPC_PERTURB_ODD 0
#endif

#ifndef DP_TEETHING
#define DP_TEETHING 0
#endif

#ifndef DP_TEETHING_PERTURBATION
#define DP_TEETHING_PERTURBATION 1e-6
#endif

#ifndef DP_HEUR_MIN_DOM
#define DP_HEUR_MIN_DOM 3
#endif

#ifndef DP_HEUR_CLOSE_BIAS
#define DP_HEUR_CLOSE_BIAS 0.1
#endif

#ifndef DP_HEUR_MORE_DOM_BIAS
#define DP_HEUR_MORE_DOM_BIAS 0.65
#endif

#ifndef DP_HEUR_BACKTRACK_K
#define DP_HEUR_BACKTRACK_K 10
#endif

#ifndef OLD_HEURISTIC
#define OLD_HEURISTIC 0
#endif

#ifndef NEW_HEURISTIC
#define NEW_HEURISTIC 1
#endif

#ifndef WHICH_HEURISTIC
#define WHICH_HEURISTIC 1
#endif

#ifndef __DPFINDTREE_F__
#define __DPFINDTREE_F__

/* this define the type of function that generate trees */
typedef int (*DPfindTree_f) (int ncount,
														 int ecount,
														 int *elist,
														 double *wlist,
														 int *tlist,
														 void *function_data);
#endif

#endif
