/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
/* Column definitions to work with CPLEX or LP in general
 *
 * Version 0.0.1 2003-04-11
 *
 * Revision 0.0.2 2003-05-07	- Fix memory leack in EGrowInit
 *
 * */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "eg_cplexTypes.h"
#include "eg_mempool.h"
#include "eg_list.h"
#include "eg_macros.h"
#ifndef __EG_CPLEX_ROW_H__
#define __EG_CPLEX_ROW_H__

/* structure to store rows */
typedef struct
{
	/* the structure stored in the EGrow_t list is EGcplexData_t defined 
	 * in eg_cplexTypes.h */
	EGlist_t *list;
	char *name;
	double rhs;
	char sense;
}
EGrow_t;

/* return a pointer to an initialized EGrow object */
EGrow_t *EGnewRow (EGmemPool_t * mempool);

/* this function reset a row */
int EGrowClear (EGrow_t *);

/* liberate the memory returned by EGnewRow, __NEVER__ liberate such a memory 
 * space with free */
void EGfreeRow (void *);

/* this function just add the pair (int,double) to the list in EGrow, but it 
 * does not check if there is another entry with the same integer, i.e. if you
 * add a constrain  * twice you will have two entries for the same constrain, 
 * and this will lead to an  * error when we add the constraint or column 
 * to CPLEX */
void EGrowAddCoeff (EGrow_t *,
										const int,
										const double);

/* change the name, objective lowe and upper bound of a column */
void EGrowInit (EGrow_t *,
								const char *name,
								const int sense,
								const double rhs);

/* this is for testing purposes only, you should call this function before 
 * running just to be sure the structures are OK */
void EGrowTest (void);
#endif
