/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
#ifndef EG_MENGER
#define EG_MENGER

#include <stdio.h>
#include <stdlib.h>
#include "eg_mempool.h"
#include "eg_list.h"
#include "eg_dgraph.h"
#include "eg_dijkstra.h"
#include "eg_heap.h"
#include "eg_bellford.h"

/* for safety one can use bellman-ford, which allows negative edges. BUT ITS SLOW!!! */
#define MENGER_USE_BELLFORD 0

#define EG_MENGER_NUMOS 14

#define EG_MENGER_PI 0
#define EG_MENGER_DIST 1
#define EG_MENGER_ORIG_DIST 2
#define EG_MENGER_NDIST 3
#define EG_MENGER_ORIG_NDIST 4
#define EG_MENGER_MARK 5
#define EG_MENGER_ORIG_MARK 6
#define EG_MENGER_FATHER 7
#define EG_MENGER_ORIG_FATHER 8
#define EG_MENGER_HEAP_CONNECTOR 9

#define EG_MENGER_ECOST 10
#define EG_MENGER_REDUCED_ECOST 11
#define EG_MENGER_IS_IN_SOL 12
#define EG_MENGER_EDATA 13

#ifndef EG_MENGER_SAFEMODE
#define EG_MENGER_SAFEMODE 0
#endif

#define EGmengerSetPi(n,os,c) \
	EGosSetData(((EGdGraphNode_t*)n)->data, os[EG_MENGER_PI], EGdijkstraCost_t, c)
#define EGmengerSetDist(n,os,d) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_DIST], EGdijkstraCost_t, f)
#define EGmengerSetOrigDist(n,os,d) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_ORIG_DIST], EGdijkstraCost_t, d)
#define EGmengerSetNdist(n,os,d) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_NDIST], unsigned int, d)
#define EGmengerSetOrigNdist(n,os,d) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_ORIG_NDIST], unsigned int, d)
#define EGmengerSetMark(n,os,m) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_MARK], unsigned int, m)
#define EGmengerSetOrigMark(n,os,m) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_ORIG_MARK], unsigned int, m)
#define EGmengerSetFather(n,os,f) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_FATHER], EGdGraphEdge_t*, f)
#define EGmengerSetOrigFather(n,os,f) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_ORIG_FATHER], EGdGraphEdge_t*, f)
#define EGmengerSetHeapConnector(n,os,hc) \
	EGosSetData(((EGdGraphNode_t*)(n))->data, os[EG_MENGER_HEAP_CONNECTOR], EGheapConnector_t*, hc)

#define EGmengerSetEdgeCost(e,os,c) \
	EGosSetData(((EGdGraphEdge_t*)(e))->data, os[EG_MENGER_ECOST], EGdijkstraCost_t, c)
#define EGmengerSetEdgeReducedCost(e,os,c) \
	EGosSetData(((EGdGraphEdge_t*)(e))->data, os[EG_MENGER_REDUCED_ECOST], EGdijkstraCost_t, c)
#define EGmengerSetEdgeIsInSolution(e,os,yn) \
	EGosSetData(((EGdGraphEdge_t*)(e))->data, os[EG_MENGER_IS_IN_SOL], unsigned int, yn)
#define EGmengerSetEdgeData(e,os,d) \
	EGosSetData(((EGdGraphEdge_t*)(e))->data, os[EG_MENGER_EDATA], void*, d)

#define EGmengerGetPi(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_PI],EGdijkstraCost_t))
#define EGmengerGetDist(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_DIST],EGdijkstraCost_t))
#define EGmengerGetOrigDist(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_ORIG_DIST],EGdijkstraCost_t))
#define EGmengerGetNdist(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_NDIST],unsigned int))
#define EGmengerGetOrigNdist(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_ORIG_NDIST],unsigned int))
#define EGmengerGetMark(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_MARK],unsigned int))
#define EGmengerGetOrigMark(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_ORIG_MARK],unsigned int))
#define EGmengerGetFather(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_FATHER],EGdGraphEdge_t*))
#define EGmengerGetOrigFather(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_ORIG_FATHER],EGdGraphEdge_t*))
#define EGmengerGetHeapConnector(v,os) \
	(EGosGetData(((EGdGraphNode_t*)(v))->data,os[EG_MENGER_HEAP_CONNECTOR],EGheapConnector_t*))

#define EGmengerGetEdgeCost(v,os) \
	(EGosGetData(((EGdGraphEdge_t*)(v))->data,os[EG_MENGER_ECOST],EGdijkstraCost_t))
#define EGmengerGetEdgeReducedCost(v,os) \
	(EGosGetData(((EGdGraphEdge_t*)(v))->data,os[EG_MENGER_REDUCED_ECOST],EGdijkstraCost_t))
#define EGmengerGetEdgeIsInSolution(v,os) \
	(EGosGetData(((EGdGraphEdge_t*)(v))->data,os[EG_MENGER_IS_IN_SOL],unsigned int))
#define EGmengerGetEdgeData(v,os) \
	(EGosGetData(((EGdGraphEdge_t*)(v))->data,os[EG_MENGER_EDATA],graphNodeP))

int EGmengerEmergencyRecovery (EGdGraph_t * G,
															 size_t * os);

int EGmengerPathsADV (EGdGraphNode_t * s,
											EGdGraphNode_t * t,
											EGdijkstraCost_t ubound,
											unsigned int npaths,
											unsigned int *nfpaths,
											EGdijkstraCost_t * menger_val,
											EGheap_t * h,
											size_t * os,
											EGdGraph_t * G);

int EGmengerRecoverGraphAndSolution (EGdGraph_t * G,
																		 size_t * os,
																		 EGdGraphNode_t * s,
																		 EGdGraphNode_t * t,
																		 unsigned int npath,
																		 EGdGraphEdge_t ** path,
																		 unsigned int *path_beg);

#endif
