/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */

/* ========================================================================= */
/* input/output utilities
 *
 * Version 0.0.2 2003-05-09 (Marcos)
 *
 * Added the function EGioNParse to get a more argc, argv feel.
 * Also: Changed EGioParse so that it ignores multiple sequential delimiters.
 * 
 * Version 0.0.1 2003-04-11
 * - 2004-08-17
 * 					-	Add EGdisplayString function.
 *
 * */
/* ========================================================================= */

#ifndef __EG_IO_H__
#define __EG_IO_H__
#include <string.h>
#include <strings.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "eg_macros.h"
/* ========================================================================= */
/* type of functions for display, receives a void* to the structure to print,
 * and a *FILE where to output */
/* ========================================================================= */
typedef void (*EGdisplay_f) (void *,
														 FILE *);
#define EGnullDisplay ((EGdisplay_f)0)

/* ========================================================================= */
/* type of functions for display, receives a void* to the structure to print, a
 * *FILE where to output, and a set of offsets for datas, the length of that
 * array must be know by the user. */
/* ========================================================================= */
typedef void (*EGdisplayOS_f) (void *,
															 FILE *,
															 size_t *);

/* ========================================================================= */
/* create names with indices */
void EGmvar (char *str,
						 int nind,
						 const char *header,
						 ...);

/* ========================================================================= */
/* Given a string 'input' this function uses EGioParse to separate
 * up to N words in it, we assume that argc is an array of pointers to strings
 * of size N, and note that the input array will be changed. */
void EGioNParse (char *input,
								 int max_argc,
								 const char *delim,
								 const char *comment,
								 int *argc,
								 char **argv);

/* ========================================================================= */
/* given two *pointers 'next' and 'current' and a constant set 
 * of strings (parse delimiters), it store in 'next the next 
 * meaningfull string, and in current the rest of the secuence, 
 * the idea is to iterate over 'next' while it is not true; 
 * you have to store the original pointer to the string stream 
 * elsewere; also, we assume that the original stream is 
 * terminated with '\0'; also, it will discaard any sub-string 
 * that start with #, that is inteded for discard comments */
void EGioParse (char **next,
								char **current,
								const char *delim,
								const char *coment);

/* ========================================================================= */
/* this discard all lines starting with comments and stores the next 
 * leading line in current and the next token in next, we assume that next 
 * does not contain data, and that current store the remainings of the
 * current line */
void EGioDisCom (char **next,
								 char **current,
								 const char *delim,
								 const char *coment,
								 char *store,
								 unsigned int storeSize,
								 FILE * in);

/* ========================================================================= */
/** @brief display function for strings
 * @param str pointer to a null terminated string of chars.
 * @param file pointer to a stream where we write the string.
 * @par Description:
 * This function just print the string on the file, it won't add a '\n' at the
 * end. */
void EGdisplayString (void *str,
											FILE * file);

#endif
