/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
#include "eg_equiset.h"

/* ========================================================================= */
/* interface functions */
EGequiSetElem_t *EGnewEquiSet (EGmemPool_t * mem,
															 void *this)
{
	/* local variables */
	EGequiSetElem_t *v;

	/* basic set-up */
	v = (EGequiSetElem_t *) EGmemPoolMalloc (mem, sizeof (EGequiSetElem_t));
	v->rank = 0;
	v->father = v;
	v->this = this;

	/* ending */
	return v;
}

/* ========================================================================= */
EGequiSetElem_t *EGequiSetFind (EGequiSetElem_t * w)
{
	/* local variables */
	EGequiSetElem_t *p = w->father;

	/* ending */
	return (w == p) ? w : (w->father = EGequiSetFind (p));
}

/* ========================================================================= */
EGequiSetElem_t *EGequiSetLink (EGequiSetElem_t * u,
																EGequiSetElem_t * v)
{
	/* local variables */
	EGequiSetElem_t *w;

	/* some tests */
	EXITL (3, v != v->father, "v is not a representant for its class");
	EXITL (3, u != u->father, "u is not a representant for its class");

	/* pick the biggest one */
	if (u->rank < v->rank)
	{
		w = u;
		u = v;
		v = w;
	}

	if (u->rank == v->rank)
	{
		u->rank++;
	}

	/* now we know that rank->u > rank->v */
	v->father = u;

	/* ending */
	return u;
}

/* ========================================================================= */
/* this function reset a set element to a singleton with the new parameter */
void EGequiSetReset (EGequiSetElem_t * u,
										 void *elem)
{
	u->father = u;
	u->rank = 0;
	u->this = elem;
	return;
}

/* ========================================================================= */
void EGfreeEquiSetElem (void *elem,
												EGmemPool_t * mem)
{
	EGmemPoolFree (elem, sizeof (EGequiSetElem_t), mem);
}
