/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
#ifndef _EGDIJKSTRAAPP
#define _EGDIJKSTRAAPP

#include "eg_dijkstra.h"

#define EGdijkstraSetOs(os) { \
	os[EG_DIJ_DIST] = offsetof (EGdijkstraNodeData_t, dist); \
	os[EG_DIJ_NDIST] = offsetof (EGdijkstraNodeData_t, ndist); \
	os[EG_DIJ_FATHER] = offsetof (EGdijkstraNodeData_t, father); \
	os[EG_DIJ_MARKER] = offsetof (EGdijkstraNodeData_t, marker); \
	os[EG_DIJ_HCONNECTOR] = offsetof (EGdijkstraNodeData_t, hc); \
	os[EG_DIJ_ELENGTH] = 0; \
	} \

typedef struct
{

	EGdijkstraCost_t dist;
	unsigned int ndist;
	unsigned int marker;
	EGdGraphEdge_t *father;
	EGheapConnector_t *hc;
	void *data;

}
EGdijkstraNodeData_t;

typedef EGdijkstraCost_t EGdijkstraEdgeData_t;

EGdijkstraNodeData_t *EGnewDijkstraNodeData (EGmemPool_t * mem);

EGdGraph_t *EGdijkstraLoadGraph (FILE * file,
																 EGmemPool_t * mem);

EGdGraph_t *EGnewDijkstraDGraph (EGmemPool_t * mem,
																 unsigned int nnodes,
																 unsigned int nedges,
																 unsigned int *edges,
																 EGdijkstraCost_t * weight);

EGdGraph_t *EGnewDijkstraDGraph_simple (EGmemPool_t * mem,
																				unsigned int nnodes,
																				unsigned int nedges,
																				unsigned int *edges,
																				EGdijkstraCost_t * weight);

EGdijkstraEdgeData_t *EGnewDijkstraEdgeData (EGmemPool_t * mem);

void EGfreeDijkstraEdgeDataMP (void *v,
															 EGmemPool_t * mem);
void EGfreeDijkstraNodeDataMP (void *v,
															 EGmemPool_t * mem);
void EGdijkstraClearDGraphMP (void *v,
															EGmemPool_t * mem);

int EGdijkstraShortestPath (EGdGraphNode_t * s,
														EGdGraphNode_t * t,
														EGdijkstraCost_t ubound,
														EGdijkstraCost_t * dist,
														EGdGraphEdge_t * prec,
														EGdGraph_t * G);

void EGdijkstraDisplayEdge (void *v,
														FILE * file);

void EGdijkstraDisplayNode (void *v,
														FILE * file);

int EGdijkstraGetOptimalPath (EGdGraph_t * G,
															EGdGraphNode_t * t,
															size_t * os,
															unsigned int *npath,
															EGdGraphEdge_t *** path,
															EGmemPool_t * mem);

#endif
