/* Copyright (c) 2005 by John M. Boyer, All Rights Reserved.  Please see
 * License.txt for use and redistribution license. */
#ifndef _COOK_INT_H
#define _COOK_INT_H

#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include "graph_boyer.h"
#include "platformTime.h"
#include "eg_macros.h"
int loadCookGraph (char *file_name,
									 int *nnodes,
									 int *nedges,
									 int **edges,
									 double **weight);
int cook2boyerGraph (graphP bGraph,
										 int nnodes,
										 int nedges,
										 int *edges);
void _AddArcWid (graphP theGraph,
								 int u,
								 int v,
								 int arcPos,
								 int _link,
								 int id);
int gp_AddEdgeWid (graphP theGraph,
									 int u,
									 int ulink,
									 int v,
									 int vlink,
									 int id);
int extractCookEdgeIds (graphP theGraph,
												int *nmnodes,
												int *nmedges,
												int *medges);
int DPprintEmbed (graphP theGraph,
									FILE * file);

/********************************************************************
 gp_AddEdgeWid()
 Adds the undirected edge (u,v) to the graph by placing edge records
 representing u into v's circular edge record list and v into u's
 circular edge record list.

 upos receives the location in G where the u record in v's list will be
        placed, and vpos is the location in G of the v record we placed in
 u's list.  These are used to initialize the short circuit links.

 ulink (0|1) indicates whether the edge record to v in u's list should
        become adjacent to u by its 0 or 1 link, i.e. u[ulink] == vpos.
 vlink (0|1) indicates whether the edge record to u in v's list should
        become adjacent to v by its 0 or 1 link, i.e. v[vlink] == upos.

 ********************************************************************/
int gp_AddEdgeWid (graphP theGraph,
									 int u,
									 int ulink,
									 int v,
									 int vlink,
									 int id);

#endif /*  */
