#include "eg_ddomino.h"
#include "cookInterface.h"
#include "eg_list.h"
#include "eg_menger.h"
#include "eg_mempool.h"
#include "eg_ddpconstraint.h"
#include "dp_config.h"
#include "graph_boyer.h"
#define EGPDP_DBGLVL 1000
#define EGU2_LVL 1000
#define EGFDOM_LVL 1000
#define EGFD2DOM_LVL 1000
#define EGPDP_FIX2PIE 1
#define EGPDP_GETP2P 1
#define EGGP2P_LVL 1000

int EGfixDualDominos (EGlist_t * domino_list,	/* dual dominos to be fixed */

											int nnodes,	/* number of nodes in primal graph */

											int nedges,	/* number of edges in primal graph */

											double *const weight,	/* weight of all non small edges */

											int *const edges,	/* non small edges in cook's format */

											int *const elim_edges,	/* index of eliminated edges */

											int nelim_edges,	/* size of the array elim_edges */

											graphP G,	/* pointer to the dual graph in boyer's format */

											EGmemPool_t * mem);	/* memory pool */

int EGgetPrimalDP (EGddpConstraint_t * ddp,	// dual DP constraint 

									 int nnodes,	// number of nodes in primal graph

									 int nedges,	// number of edges in primal graph

									 int *const edges,	// non small edges in cook's format

									 int *const elim_edges,	// index of eliminated edges

									 int nelim_edges,	// size of the array elim_edges

									 double *const weight,	// weight of all non small edges

									 int *const ndom,	// store number of dominos

									 int **const nAset,	// store the size of A each sets

									 int **const nBset,	// store the size of B each sets

									 int *const nHandle,	// store the size of the handle

									 int ***const Aset,	// store each A set

									 int ***const Bset,	// store each B set

									 int **const Handle,	// store the handle

									 double *const violation,	// primal violation of the cut

									 graphP G,		// pointer to the dual graph in boyer's format

									 EGmemPool_t * const mem);	// memory pool


/* given a list of dominos of type DOM_DUAL_NORM and the dual (planar) graph we
 * untangle all domino-paths and set path[1] as the longest one. mem is the
 * memory pool from where the dominos where allocated. embed is the dual planar
 * embed as returned by getDualBoyer. */
int EGuntangleAllDomino (EGlist_t * ddom_list,
												 EGdGraph_t * dgraph,
												 EGlist_t ** embed,
												 EGmemPool_t * mem);
