#include "eg_emptyhandles.h"
int DPremoveEmptyHandles (int *const nIneq,
													int **const ndominoes,
													int ***const naset,
													int ***const nbset,
													int **const nhandle,
													int ****const aset,
													int ****const bset,
													int ***const handle)
{

	int nIneq2 = 0;
	int *ndominoes2 = 0;
	int **naset2 = 0;
	int **nbset2 = 0;
	int *nhandle2 = 0;
	int ***aset2 = 0;
	int ***bset2 = 0;
	int **handle2 = 0;

	int i,
	  cnt = 0,
	  d,
	  nelim = 0;

	for (i = 0; i < *nIneq; i++)
		if ((*nhandle)[i] == 0)
			nelim += 1;

	nIneq2 = *nIneq - nelim;
	if (!nelim)
		return 0;

	ndominoes2 = EGsMalloc (int, nIneq2);
	naset2 = EGsMalloc (int *,
											nIneq2);
	nbset2 = EGsMalloc (int *,
											nIneq2);
	nhandle2 = EGsMalloc (int,
												nIneq2);
	aset2 = EGsMalloc (int **,
										 nIneq2);
	bset2 = EGsMalloc (int **,
										 nIneq2);
	handle2 = EGsMalloc (int *,
											 nIneq2);

	for (i = 0; i < *nIneq; i++)
	{
		if ((*nhandle)[i] == 0)
		{
			for (d = 0; d < (*ndominoes)[i]; d++)
			{
				EGfree ((*aset)[i][d]);
				EGfree ((*bset)[i][d]);
			}
			EGfree ((*naset)[i]);
			EGfree ((*nbset)[i]);
			EGfree ((*aset)[i]);
			EGfree ((*bset)[i]);
		}
		else
		{
			ndominoes2[cnt] = (*ndominoes)[i];
			naset2[cnt] = (*naset)[i];
			nbset2[cnt] = (*nbset)[i];
			nhandle2[cnt] = (*nhandle)[i];
			aset2[cnt] = (*aset)[i];
			bset2[cnt] = (*bset)[i];
			handle2[cnt] = (*handle)[i];
			cnt += 1;
		}
	}

	EGfree (*ndominoes);
	EGfree (*naset);
	EGfree (*nbset);
	EGfree (*nhandle);
	EGfree (*aset);
	EGfree (*bset);
	EGfree (*handle);

	*ndominoes = ndominoes2;
	*naset = naset2;
	*nbset = nbset2;
	*nhandle = nhandle2;
	*aset = aset2;
	*bset = bset2;
	*handle = handle2;

	*nIneq = nIneq2;
	fprintf (stderr, "Eliminated %d empty-handle DP contraints\n", nelim);

	return 0;

}
