#ifndef _EGddomino
#define _EGddomino

#include<stdio.h>
#include<math.h>
#include<limits.h>

#ifndef CCtsp_DOMINO_PORT
#define CCtsp_DOMINO_PORT ((unsigned short) 24869)
#endif

#ifndef CCtsp_DOMINO_WORK
#define CCtsp_DOMINO_WORK        'A'
#endif
#ifndef CCtsp_DOMINO_GRAPH
#define CCtsp_DOMINO_GRAPH       'G'
#endif
#ifndef CCtsp_DOMINO_NO
#define CCtsp_DOMINO_NO          'N'
#endif
#ifndef CCtsp_DOMINO_RECEIVE
#define CCtsp_DOMINO_RECEIVE     'R'
#endif
#ifndef CCtsp_DOMINO_SEND
#define CCtsp_DOMINO_SEND        'S'
#endif
#ifndef CCtsp_DOMINO_WAIT
#define CCtsp_DOMINO_WAIT        'W'
#endif
#ifndef CCtsp_DOMINO_YES
#define CCtsp_DOMINO_YES         'Y'
#endif
#ifndef CCtsp_DOMINO_EXIT
#define CCtsp_DOMINO_EXIT        'X'
#endif

#include "eg_dgraph.h"
#include "eg_dijkstra.h"
#define DOM_DUAL_NORM 0					/* dual domino type */
#define DOM_CC_ONE 1						/* consecutive-one domino */

typedef struct
{

	EGdijkstraCost_t value, primalValue;
	EGdGraphNode_t *s, *t;
	void ***path;									/* if type is DOM_DUAL_NORM, it store pointers to 
																 * EGdGraphEdge_t, if type is DOM_CC_ONE it store 
																 * pointers to edge */
	unsigned int *npath;
	unsigned char DDtype;					/* can take values: DOM_DUAL_NORM (normal value) DOM_CC_ONE*/
	unsigned int id;
} EGddomino_t;

#include "eg_util.h"
#include "bc_util.h"
#include "dp_config.h"
#include "eg_heap.h"
#include "eg_menger.h"
#include "eg_menger_app.h"

EGddomino_t *EGnewDdomino (EGmemPool_t * mem,
													 EGdGraphEdge_t ** path,
													 unsigned int *path_beg,
													 EGdijkstraCost_t val);

void EGfreeDdomino (void *v,
										EGmemPool_t * mem);
int EGfreeAllDDominoes (EGlist_t * dlist,
												EGmemPool_t * mem);

int EGddominoComputeAll (EGmemPool_t * mem,
												 EGdGraph_t * G,
												 EGlist_t * dlist,
												 int k,
												 double percentage);

int EGddominoComputeAllRemote (EGmemPool_t * mem,
															 EGdGraph_t * G,
															 EGlist_t * dlist,
															 int k,
															 const char *boss_name,
															 double ddp_heuristic_maxtime);

int EGddominoComputeS (EGmemPool_t * mem,
											 EGdGraphNode_t * s,
											 EGdGraph_t * G,
											 EGlist_t * dlist,
											 int k,
											 double percentage);

void EGddominoDisplay (EGddomino_t * ddom,
											 FILE * file);

int EGddominoPerturb (EGdGraph_t * G,
											EGdijkstraCost_t epsilon);
EGdijkstraCost_t EGddWeight (EGddomino_t * dd);
int EGddFixValues (EGlist_t * dd_list);

#endif
