#ifndef __2P_TIGHTEN_C__
#define __2P_TIGHTEN_C__

/* ========================================================================= */
/* define the debug level to use for this program, the efect depend on the DEBUG
 * constant defined at compile time, if that variables is >= to the level
 * indicated here we will make more tests */
#define KPT_DBG 90							/* test basic conditions */
#define KPT_EDBG 90							/* make exhaustive test of conditions */
#define KPT_VRB 90							/* fully log the program trace */

/* ========================================================================= */
/* given a residual graph G^*, and a valid 2P inequality, it will try to find a
 * 'more' violated 2P-inequality constraint; the function will not touch the
 * data abour the graph nor about the original inequality, but it will alloc
 * memory for all data in the new returned inequality. Note too that the number
 * of dominos of the new inequality is the same as in the original inequality.
 * Finaly, the violation (if it is negative) of the new inequality is returned
 * in (*violation). If an error occurs the function will return 1, zero on
 * success (this doesn't imply that we were able to find a violated constraint
 * from the original onw */
int KPtighten (									/* graph G* data */
								int const n_nodes,
								int const n_edges,
								int const *const edges,
								double const *const weight,
								/* original constrain to tighten */
								int const n2dominos,
								int const *const naset,
								int const *const nbset,
								int const *const ntset,
								int const nahandle,
								int const nbhandle,
								int **const aset,
								int **const bset,
								int **const tset,
								int const *const ahandle,
								int const *const bhandle,
								/* new generated constraint */
								int **const new_naset,
								int **const new_nbset,
								int **const new_ntset,
								int *const new_nahandle,
								int *const new_nbhandle,
								int ***const new_aset,
								int ***const new_bset,
								int ***const new_tset,
								int **const new_ahandle,
								int **const new_bhandle,
								double *const violation);
#endif
