/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
#ifndef EG_MENGER_APP
#define EG_MENGER_APP

#include "eg_macros.h"
#include "eg_mempool.h"
#include "eg_list.h"

#include "eg_heap.h"
#include "eg_dgraph.h"
#include "eg_dijkstra.h"
#include "eg_menger.h"

typedef struct
{

	EGdijkstraCost_t cost,
	  reduced_cost;
	void *is_in_solution;
	void *data;

}
EGmengerEdgeData_t;

typedef struct
{

	/* for menger */
	EGdijkstraCost_t pi;

	/* for dijkstra */
	EGdijkstraCost_t dist,
	  orig_dist;
	unsigned int ndist,
	  orig_ndist;
	unsigned int marker,
	  orig_marker;
	EGdGraphEdge_t *father,
	 *orig_father;
	EGheapConnector_t *hc;

}
EGmengerNodeData_t;

EGmengerNodeData_t *EGnewMengerNodeData (EGmemPool_t * mem);
EGmengerEdgeData_t *EGnewMengerEdgeData (EGmemPool_t * mem);

void EGfreeMengerEdgeDataMP (void *v,
														 EGmemPool_t * mem);
void EGfreeMengerNodeDataMP (void *v,
														 EGmemPool_t * mem);

EGdGraph_t *EGnewMengerGraph (EGmemPool_t * mem,
															int nNodes,
															int nEdges,
															int *edges,
															EGdijkstraCost_t * weight,
															size_t ** os);

int EGmengerPathsBAS (unsigned int s,
											unsigned int t,
											EGdijkstraCost_t ubound,
											EGdijkstraCost_t * menger_val,
											unsigned int npaths,
											unsigned int *iedges,
											unsigned int *iedges_beg,
											int nNodes,
											int nEdges,
											int *edges,
											EGdijkstraCost_t * weight,
											EGmemPool_t * mem);

int EGmengerPaths (EGdGraphNode_t * s,
									 EGdGraphNode_t * t,
									 EGdijkstraCost_t ubound,
									 EGdijkstraCost_t * menger_val,
									 unsigned int npaths,
									 EGdGraphEdge_t ** pedges,
									 unsigned int *pedges_beg,
									 size_t * os,
									 EGdGraph_t * G);

void EGmengerDisplayEdgeBasic (void *v,
															 FILE * file);

void EGmengerDisplayEdgeData (void *v,
															FILE * file);
void EGmengerDisplayNodeData (void *v,
															FILE * file);

void EGmengerSetOs (size_t ** os,
										EGmemPool_t * mem);

EGdijkstraCost_t EGmengerEdgeCost (EGdGraphEdge_t * e);

#endif
