/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
#ifndef _EGDAGSP
#define _EGDAGSP

#include<stdio.h>
#include<stdlib.h>

#include "eg_dgraph.h"
#include "eg_dijkstra.h"
#include "eg_macros.h"

int EGdagsp (EGdGraphNode_t * s,
						 size_t * os,
						 EGdGraph_t * G);
void EGdagspInitialize (EGdGraphNode_t * s,
												EGdGraph_t * G,
												size_t * os);
void EGdagspRelax (EGdGraphEdge_t * e,
									 size_t * os);
int EGdagspTopologicSort (EGdGraph_t * G,
													EGdGraphNode_t * s,
													EGlist_t * sort,
													size_t * os,
													EGmemPool_t * mem);

#endif
