/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
/* ========================================================================= */
/** Main Configuration for the library, as debug levels and so on
 * 
 * @par History:
 * - 2005-08-17
 * 					- Set memory aligment to 8 bits
 * - 2003-06-02
 * 					- First Implementation
 * @version 0.0.1 
 * */
/* ========================================================================= */
#ifndef __EG_CONGIH_H__
#define __EG_CONFIG_H__
#define _XOPEN_SOURCE 600
#include <stdlib.h>

/* ========================================================================= */
/* Operating system definitions, so far we can choose LINUX or SUN */
/* ========================================================================= */
#define LINUX 0
#define SUN 1
#ifndef OS
#define OS LINUX
#endif
#if ( (OS > SUN) || (OS < LINUX) )
#error OS configuration value unknown
#endif

/* ========================================================================= */
/* Debug options, by defoult set on */
/* ========================================================================= */
#ifndef DEBUG
#define DEBUG 1
#endif

/* ========================================================================= */
/* EG_BIT options */
/* ========================================================================= */
/* the debug level indicates what is the minimum debug level to start generating
 * messages of the operation for this suit, by defoult is 10, note that the
 * lower the level, the more messages that we will generate. */
#ifndef __EGBIT_DEBUG_LEVEL__
#define __EGBIT_DEBUG_LEVEL__ 10
#endif

/* ========================================================================= */
/* EG_HASH options */
/* ========================================================================= */
/* this macro allow us to add more debug information in the hash table */
#ifndef __EG_HASH_CHECK__
#if DEBUG
#define __EG_HASH_CHECK__ 1
#else
#define __EG_HASH_CHECK__ 0
#endif
#endif

/* this macro controls wether we support multiple elements with the same key */
#ifndef __EG_HASH_ALLOW_REPETITION__
#if DEBUG
#define __EG_HASH_ALLOW_REPETITION__ 0
#else
#define __EG_HASH_ALLOW_REPETITION__ 1
#endif
#endif

/* this macro controls whether we display statistics about the hash table */
#ifndef __EG_HASH_PROFILE__
#if DEBUG
#define __EG_HASH_PROFILE__ 1
#else
#define __EG_HASH_PROFILE__ 0
#endif
#endif

/* we can't set profile to one if the check mode is not available */
#if ((__EG_HASH_CHECK__== 0) && (__EG_HASH_PROFILE__ > 0))
#undef __EG_HASH_PROFILE__
#define __EG_HASH_PROFILE__ 0
#endif

/* ========================================================================= */
/* EG_CPLEX options */
/* ========================================================================= */
/* if we have CPLEX installed in our system, we say it here */
#ifndef __EG_HAVE_CPLEX__
#ifdef HAVE_CPLEX
#define __EG_HAVE_CPLEX__ 1
#else
#define __EG_HAVE_CPLEX__ 0
#endif
#endif
/* if set to nonzero value, the library will check for consistency all the
 * insertions and delet operations in the LP */
#ifndef __EG_CPLEX_EXTRADEBUG__
#define __EG_CPLEX_EXTRADEBUG__ 0
#endif

/* ========================================================================= */
/* EG_FP options */
/* ========================================================================= */
/* this enable check of overflows in the EGfp_t operations, this means that if
 * we perform an overflow operation, or work with overflow numbers, the resoult
 * will have the overflow bit set. */
#ifndef __EGFP_CHECK_OVERFLOW__
#define __EGFP_CHECK_OVERFLOW__ 0
#endif

/* this enable (on top of overflow check) varbose messages when overflow is
 * detected */
#ifndef __EGFP_CHECK_VERBOSE__
#define __EGFP_CHECK_VERBOSE__ 0
#endif

/* end eg_config.h */
#endif
