/* EGlib "Efficient General Library" provides some basic structures and
 * algorithms commons in many optimization algorithms.
 *
 * Copyright (C) 2005 Daniel Espinoza and Marcos Goycoolea.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 * */
/* ========================================================================= */
/* Column manager for CPLEX
 *
 * Version 0.0.1 2003-04-11
 *
 * */
/* ========================================================================= */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "eg_cplexTypes.h"
#include "eg_list.h"
#include "eg_macros.h"
#include "eg_mempool.h"
#ifndef __EG_CPLEX_COL_H__
#define __EG_CPLEX_COL_H__

/* ========================================================================= */
/* structure to store columns */
/* ========================================================================= */
typedef struct
{
	/* the structure stored in the EGcol_t list is EGcplexData_t 
	 * defined in eg_cplexTypes.h */
	EGlist_t *list;
	double rc;
	double obj;
	double lb;
	double ub;
	char *name;
}
EGcol_t;

/* ========================================================================= */
/* return a pointer to an initialized EGcol object */
/* ========================================================================= */
EGcol_t *EGnewCol (EGmemPool_t * mempool);

/* ========================================================================= */
/* liberate the memory returned by EGnewCol, __NEVER__ liberate 
 * such a memory space with free */
/* ========================================================================= */
void EGfreeCol (void *);

/* ========================================================================= */
/* this function just add the pair (int,double) to the list in EGcol, but it 
 * does not check if there is another entry with the same integer, i.e. if 
 * you add a constrain twice you will have two entries for the same 
 * constrain, and this will lead to an error when we add the constraint or 
 * column to CPLEX */
/* ========================================================================= */
void EGcolAddCoeff (EGcol_t *,
										const int,
										const double);

/* ========================================================================= */
/* given a column, and LP number and a coefficient, this function will try to
 * find if the LP number already have an entry in the column, if so, it will add
 * the given coefficient to the previous one, if it is not in the column, it
 * will add it to the column. */
/* ========================================================================= */
void EGcolAddIncCoeff (EGcol_t *,
											 const int,
											 const double);

/* ========================================================================= */
/* change the name, objective lowe and upper bound of a column */
/* ========================================================================= */
void EGcolInit (EGcol_t *,
								const char *name,
								const double obj,
								const double lb,
								const double ub);

/* ========================================================================= */
/* this is for testing purposes only, you should call this function before 
 * running just to be sure the structures are OK */
/* ========================================================================= */
void EGcolTest (void);

/* ========================================================================= */
/* this function clear the internal coefficient data */
/* ========================================================================= */
int EGcolClear (EGcol_t *);
#endif
