#ifndef __KARGER_H
#define __KARGER_H

extern int max_numiter;
#define ALLOC(count, type)  ((type *) malloc (((count) * sizeof (type))))
#define CALLOC(count, type)  ((type *) calloc ((size_t)(count), sizeof (type)))
#define MALLOC(count, type)  ((type *) malloc ((count) * sizeof (type)))
#define IFFREE(object, type)                                            \
    {if ((object)) { free ((void *) object);  object = (type *) NULL;}}
#define SWAP(x,y,temp) {temp = x; x = y; y = temp;}

#define TOLER  0.01

#define PROCESS_OVER 0
#define PROCESS_INCOMPLETE 1
#define PROCESS_ERROR -1

typedef struct setlist{
   struct setlist *next;
   int *setv;
   int setn;
   int info;
   double cutval;
} setlist;

/* arbitrary info can be passed in; see process_cut () */
typedef struct{
   int val;
} cuts_info;

int

	karger(int nnodes, int nedges, int *elist, double *elen, int alpha,
           double bound, double maxtime, int seed, setlist **sets,
           int (*choose_edge)(int, int*, double*, double, void*, int*),
           void *process_info,
           int (*process_set)(int*, int, double, void*, setlist **)
           ),
   karg_getprob (char *fname, int *ncount, int *ecount, int **elist,
                 double **elen),
   choose_edge1(int nremain, int *edge, double *length, double tweight,
                void *process_info, int *e),
   add_cut(int *cutset, int cutsize, double cutweight, void *process_info,
           setlist **sets),
   process_cut(int *cutset, int cutsize, double cutweight, void *process_info,
               setlist **sets);

#endif /* __KARGER_H */
