#include <stdio.h>
#include "karger.h"
#include "bc_zeit.h"

extern int max_numiter;

void  karg_usage (char *f);

int main (int ac, char **av)
{
   int i;
   int rval = 0;
   int ncount, ecount, ccount=0;
   int *elist = NULL;
   double *elen = NULL;
   setlist *sets = NULL;
   setlist *oldset = NULL;
   double szeit, maxtime;
   cuts_info cinf;

	 if ( ac != 3 )
	 {
	  	fprintf(stderr, "wrong parameters. should be: file.x time\n"); goto CLEANUP;
	 }

	 maxtime = atof(av[2]);
	 fprintf(stderr, "file name = %s     time = %lf\n", av[1], atof(av[2]));

   rval = karg_getprob (av[1], &ncount, &ecount, &elist, &elen);
   if (rval) {
      fprintf (stderr, "karg_getprob failed\n"); goto CLEANUP;
   }

   cinf.val = 5;

   szeit = CCutil_zeit();
   max_numiter = 2000;
   rval = karger (ncount, ecount, elist, elen, 3, 6.0, maxtime, 0, &sets,
				  choose_edge1, (void *)(&cinf), process_cut);

   printf ("Running Time: %.2f (seconds)\n", CCutil_zeit()-szeit); fflush (stdout);

   if (sets == NULL)
      printf("No cuts; failure\n");

   while (sets != NULL){
	 		ccount += 1;
		
			i = 0;
      printf("Cut value = %f\n", sets->cutval);
			/*
      for (i=0; i<sets->setn; i++){
         printf("%d ",sets->setv[i]);
      }
      printf("\n");
			*/
			oldset = sets;
      sets = sets->next;
			free(oldset->setv);
			free(oldset);
   }
	 if(elist) free(elist);
	 if(elen) free(elen);

	 printf("Number of cuts = %d.\n", ccount);

   fflush (stdout);

CLEANUP:
   return 0;
}

