import numpy
import matplotlib
import pylab
import os
import time
from matplotlib import pyplot

def get_fig():
   fig = pyplot.figure(figsize=(10,10))
   fig.add_subplot(111,aspect='equal')
   pyplot.xlim(-200,200)
   pyplot.ylim(-200,200)
   pyplot.gca().patch.set_facecolor((0,0,0))
   cmap = pyplot.cm.hot
   fig.tight_layout()
   return fig

file_list=[]
os.chdir("/home/james/Fortran/Nbody")
def create_file_list(file_list):
   for files in os.listdir("."):
      if files.endswith(".txt"):
         file_list.append(files)
   file_list.sort()

create_file_list(file_list)

pylab.ion()
for files in file_list:
   #open output file
   f = open(files,'r')

   #define arrays from output file
   x=[]
   y=[]
   m=[]
   for line in f:
      s=line.split()
      x.append(float(s[0]))
      y.append(float(s[1]))
      m.append(float(s[2]))

   #display the frame
   pyplot.xlim(-50,50)
   pyplot.ylim(-50,50)
   pyplot.gca().patch.set_facecolor((0,0,0))
   pyplot.tight_layout()
   matplotlib.pylab.scatter(x,y,s=1,facecolor='1',lw=0)
   pylab.draw()
   #pylab.pause(0.1)
   pylab.clf()

   #close file
   f.close()
