module output
use def
implicit none


contains
   subroutine create_output_file(file_tag)
   integer :: file_tag
   integer :: i,out_unit=1
   character(len=1024) :: filename
   
    
   write(filename,"(A6,I0.4,A4)") exp_name,file_tag,".txt"

   open(unit=out_unit,file=trim(filename),action='write',status='replace')
   open(unit=2,file='kinetic.txt',action='write',status='replace')
   open(unit=3,file='potential.txt',action='write',status='replace')
   
   do i=1,npts
      write(out_unit,*) pdata(i)%x(1),' ',pdata(i)%x(2),' ',pdata(i)%mass
   enddo
   write(2,*) KE
   write(3,*) PE

   close(out_unit)
   close(2)
   close(3)

   end subroutine create_output_file
end module output
