module ic
use def
implicit none


contains
   subroutine initialize_particles_colliding(pdata,n)
   integer, intent(in) :: n
   type(particle), intent(inout), dimension(n) :: pdata

   integer :: i,j
   double precision :: mass
   double precision :: rnd1,rnd2
   
   i=1
   do while (i<=n)
      call random_number(rnd1)
      call random_number(rnd2)
      if (i==1) then
         pdata(i) % x(1) = 0.         !
         pdata(i) % x(2) = 0.         !
         pdata(i) % vel(1) = 0.       !
         pdata(i) % vel(2) = 0.       ! large blackhole for first galaxy
         pdata(i) % mass = SBH        !
         pdata(i) % id = i            !
         i = i + 1                    !
      elseif (i==2) then
         pdata(i) % x(1) = 10.                                       !
         pdata(i) % x(2) = 10.                                       !
         pdata(i) % vel(1) = -sqrt(SBH*G/sqrt(20.))*sin(pi/4)        !
         pdata(i) % vel(2) = sqrt(SBH*G/sqrt(20.))*cos(pi/4)         ! small blackhole for second glaxy
         pdata(i) % mass = SBH                                  !
         pdata(i) % id = i                                           !
         i = i + 1                                                   !
      elseif (i<0.5*n) then
         pdata(i) % x(1) = 8*rnd1*cos(2.*pi*rnd2)
         pdata(i) % x(2) = 8*rnd1*sin(2.*pi*rnd2)
         pdata(i) % vel(1) = -sqrt(SBH*G/(8*rnd1))*sin(2.*pi*rnd2)
         pdata(i) % vel(2) = sqrt(SBH*G/(8*rnd1))*cos(2.*pi*rnd2)
         pdata(i) % mass = 1.
         pdata(i) % id = i
         i = i + 1
      else
         pdata(i) % x(1) = 4*rnd1*cos(2.*pi*rnd2)+10.
         pdata(i) % x(2) = 4*rnd1*sin(2.*pi*rnd2)+10.
         pdata(i) % vel(1) = -sqrt(0.25*SBH*G/(4*rnd1))*sin(2.*pi*rnd2)
         pdata(i) % vel(2) = sqrt(0.25*SBH*G/(4*rnd1))*cos(2.*pi*rnd2)
         pdata(i) % mass = 1.
         pdata(i) % id = i
         i = i + 1
      endif
   enddo
   end subroutine initialize_particles_colliding


   subroutine initialize_particles_galaxy(pdata,n)
   integer, intent(in) :: n
   type(particle), intent(inout), dimension(n) :: pdata

   integer :: i,j
   double precision :: mass
   double precision :: rnd1,rnd2

   i = 1
   do while (i<=n)
      call random_number(rnd1)
      call random_number(rnd2)
      if (i==1) then
         pdata(i) % x(1) = 0.
         pdata(i) % x(2) = 0.
         pdata(i) % vel(1) = 0.
         pdata(i) % vel(2) = 0.
         pdata(i) % mass = SBH
         pdata(i) % id = i
         i = i + 1
      else
         pdata(i) % x(1) = 8*rnd1*cos(2.*pi*rnd2)
         pdata(i) % x(2) = 8*rnd1*sin(2.*pi*rnd2)
         pdata(i) % vel(1) = -sqrt(SBH*G/(8*rnd1))*sin(2.*pi*rnd2)
         pdata(i) % vel(2) = sqrt(SBH*G/(8*rnd1))*cos(2.*pi*rnd2)
         pdata(i) % mass = 1.
         pdata(i) % id = i
         i = i + 1
      endif
   enddo
   end subroutine initialize_particles_galaxy



   subroutine initialize_particles_uniform(pdata,n)
   integer, intent(in) :: n
   type(particle), intent(inout), dimension(n) :: pdata

   integer :: i,j
   double precision :: mass
   double precision :: rnd1,rnd2

   i = 1
   do while (i<=n)
      call random_number(rnd1)
      call random_number(rnd2)
      pdata(i) % x(1) = 2.0 * rnd1 - 1.
      pdata(i) % x(2) = 2.0 * rnd2 - 1.
      pdata(i) % vel(1) = 0.
      pdata(i) % vel(2) = 0.
      pdata(i) % mass = 1.
      pdata(i) % id = i
      i = i + 1
   enddo
   end subroutine initialize_particles_uniform

end module ic
