module energy
use def
implicit none

contains
   subroutine total_kinetic_energy(ke,pdata)
   double precision, intent(inout) :: ke
   type(particle), dimension(npts), intent(in) :: pdata

   integer :: i
   double precision :: vx,vy
   double precision :: m

   do i=1,npts
      vx = pdata(i)%vel(1)
      vy = pdata(i)%vel(2)
      m = pdata(i)%mass

      ke = ke + m*(vx**2 + vy**2)
   enddo
   ke = 0.5*ke
   end subroutine total_kinetic_energy



   subroutine total_potential_energy(pe,pdata)
   double precision, intent(inout) :: pe
   type(particle), dimension(npts) :: pdata

   integer :: i,j
   double precision :: x1i,x1j,x2i,x2j,mi,mj

   do i=1,npts
      x1i = pdata(i)%x(1)
      x2i = pdata(i)%x(2)
      mi = pdata(i)%mass
      do j=1,npts
         x1j = pdata(j)%x(1)
         x2j = pdata(j)%x(2)
         mj = pdata(j)%mass
         if (i/=j) then
            pe = pe + mi*mj/sqrt((x1i-x1j)**2+(x2i-x2j)**2+eps**2)
         endif 
      enddo
   enddo
   pe = -0.5*G*pe
   end subroutine total_potential_energy

end module energy
