module def
implicit none
type particle
   integer :: id
   double precision, dimension(2) :: x
   double precision, dimension(2) :: vel
   double precision :: mass
end type particle

type node
   double precision :: node_diameter
   double precision :: node_mass
   double precision, dimension(2) :: centre_of_mass
   type(particle) :: value
   type(node), pointer :: NW
   type(node), pointer :: NE
   type(node), pointer :: SW
   type(node), pointer :: SE
end type node

integer :: npts=20000
integer :: nsteps=80
integer :: time
integer :: out_frq=1
integer :: simulation=1
integer :: rseed=111
integer :: seed_size
integer, allocatable :: seed(:)
double precision :: pi=3.14159265
double precision :: dt=0.01
double precision :: eps=1.           !non-zero softening factor
double precision :: theta=1.          !Multiple-Accepance-Criterion
double precision :: G=0.004302        !gravitation constant in units of pc M_(o)^-1 (km/s)^2 
double precision :: SBH = 2000000      !mass of central supermassive black hole
double precision :: left=0.
double precision :: right=0.
double precision :: bottom=0.
double precision :: top=0.
double precision, allocatable :: KE(:),PE(:)

character(len=6) :: exp_name='galaxy'

type(particle), allocatable :: pdata(:)


contains
   subroutine initialize_random_seed(rseed)
   integer, intent(in) :: rseed
   call random_seed(size=seed_size) ; allocate(seed(seed_size)) ; seed=rseed
   call random_seed(put=seed)
   end subroutine initialize_random_seed
end module def
