#include<stdio.h>
#include<stdlib.h>
#include<mpi.h>
#include<time.h>

void pmatrixVectorProduct(int r[], int c[], double v[], double x[], double y[], int m, int n, int id, int np);
double pdotProduct(double x[], double y[], int m, int n, int id, int np);


int main(int argc, char **argv)
{
  double start,end;
  int ierr,nprocs,id;
  MPI_Status status;

  ierr = MPI_Init(&argc,&argv);
  ierr = MPI_Comm_rank(MPI_COMM_WORLD, &id);
  ierr = MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

  //test 6
  //if(id==0){
  //  int aar[7] = {0,1,12,20,28,32,40};
  //  int aac[40] = {0,1,2,3,4,5,6,7,8,9,10,11,1,2,4,6,7,9,10,11,
  //                 1,3,4,5,6,8,9,10,1,2,3,4,1,3,5,6,7,8,10,11};
  //  double aav[40] = {4.2,2.2,0.629,0.811,-0.746,0.826,0.264,-0.804,-0.443,0.093,0.915,0.929,
  //                  0.629,6.4,0.631,-0.591,0.613,0.651,0.712,0.732,0.811,3.3,-0.09,0.015,
  //                  -0.111,-0.189,0.073,0.212,-0.746,0.631,-0.09,5.5,0.826,0.015,7.1,1.12,
  //                  0.913,0.211,0.437,0.516};
  //  double bb[6] = {1,1,1,1,1,1};
  //  double xx[6] = {1,2,3,4,5,6};
  //  pmatrixVectorProduct(aar,aac,aav,xx,bb,6,12,id,nprocs);
  //  for(int i=0;i<6;i++){printf("%f",bb[i]);printf(" ");}    
  //}
  //else if(id==1){
  //  int aar[7] = {0,9,17,26,35,43,50};
  //  int aac[50] = {1,2,3,5,6,7,8,9,11,1,2,5,6,7,8,9,10,1,3,5,6,7,8,9,10,11,
  //                 1,2,3,6,7,8,9,10,11,1,2,3,5,7,8,9,10,1,2,5,6,8,9,11};
  //  double aav[50] = {0.264,-0.591,-0.111,1.12,4.3,0.732,-0.324,0.159,-0.632,
  //                  -0.804,0.613,0.913,0.732,2.7,0.323,-0.217,0.409,
  //                  -0.443,-0.189,0.211,-0.324,0.323,2.9,0.737,-0.412,0.831,
  //                  0.093,0.651,0.073,0.159,-0.217,0.737,4.4,0.118,-0.516,
  //                  0.915,0.712,0.212,0.437,0.409,-0.412,0.118,5.1,
  //                  0.929,0.732,0.516,-0.632,0.831,-0.516,7.3};
  //  double bb[6] = {1,1,1,1,1,1};
  //  double xx[6] = {7,8,9,10,11,12};
  //  pmatrixVectorProduct(aar,aac,aav,xx,bb,6,12,id,nprocs);
  //  for(int i=0;i<6;i++){printf("%f",bb[i]);printf(" ");}
  //}


  //test 8
  if(id==0){
    int m = 5, n = 10;
    double z = 0.0;
    double *x = malloc(m*sizeof(x));
    double *y = malloc(m*sizeof(y));
    for(int i=0;i<m;i++){x[i] = 1.0+id; y[i] = 2.0+id;}

    //start = (double)clock();
    for(int i=0;i<1000;i++){z = pdotProduct(x,y,m,n,id,nprocs);}
    //end = (double)clock();printf("%f",end-start);
    printf("%f",z);
    free(x);
    free(y);
  }
  else{
    int m = 5, n = 10;
    double z = 0.0;
    double *x = malloc(m*sizeof(x));
    double *y = malloc(m*sizeof(y));
    for(int i=0;i<m;i++){x[i] = 1.0+id; y[i] = 2.0+id;}

    for(int i=0;i<1000;i++){z = pdotProduct(x,y,m,n,id,nprocs);}
    free(x);
    free(y);
  }



  ierr = MPI_Finalize();

  return 0;
}



//-------------------------------------------------------------------------------
// sparse parallel matrix-vector product y = A*x
//-------------------------------------------------------------------------------
void pmatrixVectorProduct(int r[], int c[], double v[], double x[], double y[], int m, int n, int id, int np)
{
  double *total_x = malloc(n*sizeof(total_x));
  MPI_Allgather(x,m,MPI_DOUBLE,total_x,m,MPI_DOUBLE,MPI_COMM_WORLD);

  for(int i=0;i<m;i++){
    double s = 0;
    for(int j=r[i];j<r[i+1];j++)
      s += v[j]*total_x[c[j]];
    y[i] = s;
  }

  free(total_x);
}


//-------------------------------------------------------------------------------
// sparse parallel dot product z = x*y
//-------------------------------------------------------------------------------
double pdotProduct(double x[], double y[], int m, int n, int id, int np)
{
  double global_prod = 0.0;
  double local_prod = 0.0;
  for(int i=0;i<m;i++){
    local_prod = local_prod + x[i]*y[i];
  }

  MPI_Allreduce(&local_prod,&global_prod,1,MPI_DOUBLE,MPI_SUM,MPI_COMM_WORLD);

  return global_prod;
}
