#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<mpi.h>
#include"pAMG.h"
#include"pPCG.h"
#include"pRICH.h"


int main(int argc, char **argv)
{
  int ierr,nprocs,id;
  MPI_Status status;

  ierr = MPI_Init(&argc,&argv);
  ierr = MPI_Comm_rank(MPI_COMM_WORLD, &id);
  ierr = MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

 
  //FILE *infile =  fopen("../../tests/sevenpoint1.txt","r");      
  //int N = 580;
  //int Nr = 101;

  //FILE *infile = fopen("../../tests/sevenpoint2.txt","r");      // works 
  //int N = 68800;
  //int Nr = 10001;

  FILE *infile =  fopen("../../tests/sevenpoint3.txt","r");      // works 
  int N = 1744000;
  int Nr = 250001;

  //FILE *infile =  fopen("../../tests/sevenpoint4.txt","r");      // works 
  //int N = 3928500;
  //int Nr = 562501;

  //FILE *infile =  fopen("../../tests/mesh1em6.mtx","r");         // works 
  //int N = 177;
  //int Nr = 49;

  //FILE *infile =  fopen("../tests/mesh2em5.mtx","r");         // works 
  //int N = 1162;
  //int Nr = 307;

  //FILE *infile =  fopen("../tests/mesh3em5.mtx","r");         // works
  //int N = 1089;
  //int Nr = 290;

  //FILE *infile =  fopen("../tests/fv1.mtx","r");              // works
  //int N = 47434; 
  //int Nr = 9605;

  //FILE *infile =  fopen("../tests/fv2.mtx");              // works
  //int N = 48413; 
  //int Nr = 9802;

  //FILE *infile =  fopen("../../tests/fv3.mtx","r");              // works
  //int N = 48413; 
  //int Nr = 9802;

  //FILE *infile =  fopen("../../tests/shallow_water1.mtx","r");   // works
  //int N = 204800; 
  //int Nr = 81921;

  //FILE *infile =  fopen("../tests/shallow_water2.mtx");   // works
  //int N = 204800; 
  //int Nr = 81921;

  //FILE *infile =  fopen("../../tests/thermal1.mtx","r");         // works
  //int N = 328556; 
  //int Nr = 82655;


  char buffer[100];
  int ch = 0, length = 0, line_flag = 0, index = 0;
  int *rows = malloc(N*sizeof(rows));
  int *columns = malloc(N*sizeof(columns));
  double *values = malloc(N*sizeof(values));
  while((ch=fgetc(infile))!=EOF){
    ch = ungetc(ch,infile);
    fgets(buffer,100,infile);
    if(buffer[0]!='%'){
      length = strlen(buffer);
      char entry[10];
      int j = 0;
      int k = 0;
      double crv[3];  //column, row, value numbers in line
      for(int i=0;i<length;i++){
        if(buffer[i]!=' ' && buffer[i]!='\n'){
          entry[j] = buffer[i];
          j++;
        }
        else{
          entry[j] = ' ';
          crv[k] = atof(&entry[0]);
          k++;
          j = 0;
        }
      }

      if(line_flag){
        columns[index] = (int)crv[0]-1;
        rows[index] = (int)crv[1]-1;
        values[index] = crv[2];
        index++;
      }
      line_flag = 1;
    }
  }
  fclose(infile);

  
  int m=rows[0];
  for(int i=0;i<N;i++){
    if(rows[i]!=m){
      m=rows[i];
      if(m!=columns[i]){
        printf("WARNING: Matrix does not contain a diagonal entry in every row/column");
        return 0;
      }
    }
  }

  int Nt = 2*N-(Nr-1);  //number of entries in total sparse matrix
  int *row_total = malloc(Nt*sizeof(row_total));  //new int[Nt];
  int *col_total = malloc(Nt*sizeof(col_total));  //new int[Nt];
  double *val_total = malloc(Nt*sizeof(val_total));  //new double[Nt];

  m = rows[0];
  index = 0;
  int i=0;
  while(i<N){
    if(rows[i]!=m){
      for(int j=0;j<i;j++){
        if(columns[j]==rows[i]){
          row_total[index] = rows[i];
          col_total[index] = rows[j];
          val_total[index] = values[j];
          index++;
        }
      }
      m=rows[i];
    }
    else{
      row_total[index] = rows[i];
      col_total[index] = columns[i];
      val_total[index] = values[i];
      index++;
      i++;
    }
  }

  int *row_ptr = malloc(Nr*sizeof(row_ptr));  
  int j=0;
  int count = 0;
  row_ptr[0] = 0;
  row_ptr[Nr-1] = Nt;
  for(int i=1;i<Nt;i++){
    if(row_total[i-1]==row_total[i]){
      count++;
    }
    else{
      count++;
      j++;
      row_ptr[j] = count;
    }
  }


  ierr = MPI_Barrier(MPI_COMM_WORLD);


  //begin test
  printf("Begin test");
  m = (Nr-1)/nprocs;  //we assume divisible by nprocs
  int n = (Nr-1);
  int p = row_ptr[m*(id+1)] - row_ptr[m*id];
  double *x = malloc(m*sizeof(x));
  double *b = malloc(m*sizeof(b));
  int *ar = malloc((m+1)*sizeof(ar));
  int *ac = malloc(p*sizeof(ac));
  double *av = malloc(p*sizeof(av));
  int pp[nprocs]; pp[0] = 0; //row_ptr[m];
  //for(int i=1;i<nprocs;i++){pp[i] = pp[i-1] + row_ptr[m*(i+1)] - row_ptr[m*i];}
  for(int i=1;i<nprocs;i++){pp[i] = pp[i-1] + row_ptr[m*i] - row_ptr[m*(i-1)];}
  for(int i=0;i<m;i++){
    x[i] = 1.0;
    b[i] = 1.0;
  }
  for(int i=0;i<(m+1);i++){
    ar[i] = row_ptr[i+m*id] - row_ptr[m*id];
  }
  for(int i=0;i<p;i++){
    ac[i] = col_total[i+pp[id]];
    av[i] = val_total[i+pp[id]];
  }
  ierr = MPI_Barrier(MPI_COMM_WORLD);
 
  free(rows);
  free(columns);
  free(values);
  free(row_total);
  free(col_total);
  free(val_total);
  free(row_ptr);

  ierr = MPI_Barrier(MPI_COMM_WORLD);
  double start = MPI_Wtime();
  
  //amg(ar,ac,av,x,b,n,m,0.25,10e-8,id,nprocs);
  //int iter = ppcg(ar,ac,av,x,b,m,n,10e-8,id,nprocs);
  int iter = prich(ar,ac,av,x,b,m,n,0.25,10e-8,id,nprocs);
  if(id==0){for(int i=0;i<10;i++){printf("\n%f",x[i]);}}
  if(id==0){printf("\n%d",iter);}

  ierr = MPI_Barrier(MPI_COMM_WORLD);
  double end = MPI_Wtime();

  if(id==0){printf("\n"); printf("\n%f\n",end-start);}

  free(ar);
  free(ac);
  free(av);
  free(x);
  free(b);


  ierr = MPI_Finalize();
  
  return 0;
}

