//********************************************************************************
//
// IterSolvers: A collection of Iterative Solvers
// Written by James Sandham
// 3 March 2015
//
//********************************************************************************

//********************************************************************************
//
// IterSolvers is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************

#ifndef PSLAF_H
#define PSLAF_H

void pmatrixVectorProduct(const int r[], const int c[], const double v[], const double x[], 
                          double y[], const int m, const int n, const int id, const int np);

void pmatrixVectorProduct2(const int r[], const int c[], const double v[], const double x[], 
                           double y[], const int m, const int n, const int id, const int np, 
                           const int pmap[], const int msize);

double pdotProduct(const double x[], const double y[], const int m, const int n, 
                   const int id, const int np);

double error(const int r[], const int c[], const double v[], const double x[],
             const double b[], const int m, const int n, const int id, const int np);

#endif

