//********************************************************************************
//
// IterSolvers: A collection of Iterative Solvers
// Written by James Sandham
// 3 March 2015
//
//********************************************************************************

//********************************************************************************
//
// IterSolvers is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************

#include<stdlib.h>
#include<stdio.h>
#include"pRICH.h"
#include"pSLAF.h"
#include"math.h"
#include<mpi.h>


//****************************************************************************
//
// Parallel Richardson Iteration 
//
//****************************************************************************

#define DEBUG 0

//-------------------------------------------------------------------------------
// parallel richardson method
//-------------------------------------------------------------------------------
int prich(const int r[], const int c[], const double v[], double x[], const double b[],
          const int m, const int n, const double theta, const double tol, const int max_iter, 
          const int id, const int np)
{
  // m - number of rows of A sent to this process
  // n - total number of rows in full A and the size of the vector x and b

  //find out which processes need to send/recv data to/from the current process id
  int *temp = malloc(np*sizeof(temp));
  for(int i=0;i<np;i++){temp[i] = 0;}
  for(int i=0;i<m;i++){
    for(int j=r[i];j<r[i+1];j++){
      temp[c[j]/m] = 1;
    }
  }
  int map_size = 0, index = 0;
  for(int i=0;i<np;i++){if(temp[i]>0){map_size++;}}
  int *proc_map = malloc(map_size*sizeof(proc_map));
  for(int i=0;i<np;i++){
    if(temp[i]>0){
      proc_map[index] = i;
      index++;
    }
  }


  //res = b-A*x and initial error
  double *res = malloc(m*sizeof(res));
  pmatrixVectorProduct2(r,c,v,x,res,m,n,id,np,proc_map,map_size);
  double err = error(r,c,v,x,b,m,n,id,np);
  for(int i=0;i<m;i++){res[i] = b[i] - res[i];}
  if(err<tol){return 1;}

  int iter = 0, inner_iter = 0;
  while(iter<max_iter && err>tol){
    //find res = A*x
    pmatrixVectorProduct2(r,c,v,x,res,m,n,id,np,proc_map,map_size);

    //update approximation
    for(int i=0;i<m;i++){
      x[i] = x[i] + theta*(b[i]-res[i]);
    }

    //calculate error
    if(inner_iter==40){
      err = error(r,c,v,x,b,m,n,id,np);
      inner_iter = 0;
      #if(DEBUG)
        printf("error: ");
      #endif
    }
    iter++;
    inner_iter++;
  }

  free(temp);
  free(proc_map);
  free(res);

  return iter;
}

