//********************************************************************************
//
// IterSolvers: A collection of Iterative Solvers
// Written by James Sandham
// 3 March 2015
//
//********************************************************************************

//********************************************************************************
//
// IterSolvers is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************


#ifndef AMG_H
#define AMG_H

void amg(int r[], int c[], double v[], double x[], double b[], int n, int m, double theta, double tol, int id, int np);
void amg_init(int r[], int c[], double v[], int *ar[], int *ac[], double *av[], double *ad[], int nSizes[], int mSizes[], int n, int m, int id, int np);
int amg_setup(int *ar[], int *ac[], double *av[], double *ad[], int *wr[], int *wc[], double *wv[], int nSizes[], int mSizes[], int level, double theta, int id, int np);
int strength_matrix_size(int r[], int c[], double v[], int mptr_size, double theta, int id, int np);
void strength_matrix(int r[], int c[], double v[], int sr[], int sc[], double sv[], int lambda[], int mptr_size, double theta, int id, int np);
void strength_transpose_matrix(int sr[], int sc[], double sv[], int str[], int stc[], double stv[], int lambda[], int mptr_size, double theta, int id, int np);
void pre_cpoint(int sr[], int sc[], int str[], int stc[], int lambda[], int cfpoints[], int mptr_size, int id, int np);
void post_cpoint(int sr[], int sc[], int cfpoints[], int mptr_size, int id, int np);
int weight_matrix(int r[], int c[], double v[], double d[], int sr[], int sc[], double sv[], int *wr[], int *wc[], double *wv[], unsigned cfpoints[], int mptr_size, int level, int id, int np);
void galerkin_prod2(int *ar[], int *ac[], double *av[], double *ad[], int *wr[], int *wc[], double *wv[], int mptr_size, int m, int level, int id, int np);
inline void sort(int array1[], double array2[], int start, int end);
int compare_structs(const void *a, const void *b);

#endif
