//********************************************************************************
//*
//*  C++ finite element method for heat equation
//*  James sandham
//*  15 April 2015
//*
//********************************************************************************

//********************************************************************************
//
// HeatFE is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************


#ifndef FEMODEL_H
#define FEMODEL_H

#include"BoundaryData.h"

class FeModel
{
  public:            
    BoundaryData *bdata;    //object containing information on boundary conditions

  private:
    double c;               //specific heat coefficient                         
    double rho;             //density                            
    double Q;               //internal heat generation   
    double k;               //thermal conductivity coefficient        
    double T;               //final time                            
    double dt;              //timestep size                                
    int steps;              //number of timesteps                            
    bool time;              //time dependence flag
                                               
  public: 
    FeModel(BoundaryData *bdata);
    ~FeModel();

    void set_c(double i);
    void set_rho(double i);
    void set_Q(double i);
    void set_k(double i);
    void set_T(double i);
    void set_dt(double i);
    void set_steps(int i);
    void set_time(bool i);
   
    double get_c();
    double get_rho();
    double get_Q();
    double get_k();
    double get_T();
    double get_dt();
    int get_steps();
    bool get_time();
};

#endif
