//********************************************************************************
//*
//*  C++ finite element method for heat equation
//*  James sandham
//*  15 April 2015
//*
//********************************************************************************

//********************************************************************************
//
// HeatFE is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************

#include"FeModel.h"
#include"BoundaryData.h"


//-----------------------------------------------------------------------------
// Constructor for Finite Element Model
//-----------------------------------------------------------------------------
FeModel::FeModel(BoundaryData *bd)
{
  bdata = bd;
}  



//-----------------------------------------------------------------------------
// Destructor for Finite Element Model
//-----------------------------------------------------------------------------
FeModel::~FeModel()
{

}


//-----------------------------------------------------------------------------
// set methods
//-----------------------------------------------------------------------------
void FeModel::set_c(double i)
{
  c = i;
}


void FeModel::set_rho(double i)
{
  rho = i;
}


void FeModel::set_Q(double i)
{
  Q = i;
}


void FeModel::set_k(double i)
{
  k = i;
}


void FeModel::set_T(double i)
{
  T = i;
}


void FeModel::set_dt(double i)
{
  dt = i;
}


void FeModel::set_steps(int i)
{
  steps = i;  
}


void FeModel::set_time(bool i)
{
  time = i;
}


//-----------------------------------------------------------------------------
// get methods
//-----------------------------------------------------------------------------
double FeModel::get_c()
{
  return c;
}


double FeModel::get_rho()
{
  return rho;
}


double FeModel::get_Q()
{
  return Q;
}


double FeModel::get_k()
{
  return k;
}


double FeModel::get_T()
{
  return T;
}


double FeModel::get_dt()
{
  return dt;
}


int FeModel::get_steps()
{
  return steps;
}


bool FeModel::get_time()
{
  return time;
}
