//********************************************************************************
//*
//*  C++ finite element method for heat equation
//*  James sandham
//*  15 April 2015
//*
//********************************************************************************

//********************************************************************************
//
// HeatFE is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************

#ifndef SOLVER_H
#define SOLVER_H
#include"FeModel.h"


class Solver
{
  public:
    FeModel fem;     //finite element model
    int neq;         //number of equations (size of global matrix))
    int* nrow;       //pointers to matrix rows
    int* ncol;       //column numbers for nonzero values in A
    double* A;       //nonzero values of the global stiffness matrix by row
    double *x, *b;   //solution vector and RHS

  public: 
    Solver(FeModel fem);

    void assembleGAM();    //assemble global A matrix: A = (M+dt*K)
    void assembleGRHSV();  //assemble global RHS vector: RHS = (M*T^n+L) 
    void dirichletBC();    //apply dirichlet boundary conditions
    void writeResults();   //write solution vector x to output file
    void deleteSolver();   //delete solver

    virtual int solve() = 0;   //solve linear system
};



class SolverPCG : public Solver
{
  public: 
    SolverPCG(FeModel fem);

    virtual int solve();
};


class SolverAMG : public Solver
{
  public: 
    SolverAMG(FeModel fem);

    virtual int solve();
};


#endif
