//********************************************************************************
//*
//*  C++ finite element method for heat equation
//*  James sandham
//*  15 April 2015
//*
//********************************************************************************

//********************************************************************************
//
// HeatFE is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************


#ifndef FEMODEL_H
#define FEMODEL_H

class FeModel
{
  public:
    char* model;            //model .msh file name                       *
    int Dim;                //dimension of problem (1, 2, or 3)          * 
    int N;                  //total number of nodes                      *
    int Nte;                //total number of elements (Nte=Ne+Nb)       *
    int Ne;                 //number of interior elements                *
    int Nb;                 //number of boundary elements                *
    int Ng;                 //number of element groups                   *
    int Npe;                //number of points per interior element      * read from .msh file
    int Nbpe;               //number of points per boundary element      *
    int Type;               //interior element type                      *
    int bType;              //boundary element type                      *
    double *xpoints;        //x-points of nodes                          *
    double *ypoints;        //y-points of nodes                          *
    double *zpoints;        //z-points of nodes                          *
    int **connect;          //connectivity for interior elements         *
    int **bconnect;         //connectivity for boundary elements         *


    double E;               //elasticity modulus                         *
    double mu;              //Poisson's ratio                            *
    double alpha;           //coefficient of thermal expansion           *
    double T;               //nodal temperature                          *  
    double dt;              //timestep size                              *  
    int steps;              //number of timesteps                        *    
    bool time;              //time dependence flag                       *  read from model.txt
    int nDirGrps;           //number of dirichlet boundary groups        *
    int nHFGrps;            //number of heat flux boundary groups        *
    int nCGrps;             //number of convection boundary groups       *
    int *dirichletGrps;     //dirichlet boundary groups                  *
    int *heatFluxGrps;      //heat flux boundary groups                  *
    int *convectionGrps;    //connvection boundary groups                *
    double *dirichletVals;  //dirichlet boundary values                  *
    double *heatFluxVals;   //heat flux boundary values                  *
    double *convectionVals; //connvection boundary values                *
                                               
  public: 
    FeModel(char* f);

    void readModel();
    void deleteModel();

  private:
    void display();
};

#endif
